/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.additionalFields;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.cxbox.core.config.cache.CxboxCachingService;
import org.cxbox.core.dto.RequestDTO;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.util.ResponseBuilder;
import org.cxbox.meta.additionalFields.AdditionalFieldsDTO;
import org.cxbox.meta.additionalFields.AdditionalFieldsService;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{'${cxbox.api.path}'}/personalAdditionalFields"})
public class AdditionalFieldsController {
    private final AdditionalFieldsService additionalFieldsService;
    private final CxboxCachingService cxboxCachingService;

    @RequestMapping(method={RequestMethod.POST})
    public ResponseDTO createAdditionalFields(@RequestBody RequestDTO<List<AdditionalFieldsDTO>> requestDTO) {
        List<AdditionalFieldsDTO> additionalFieldsListResponse = this.additionalFieldsService.createAdditionalFields((List)requestDTO.getData());
        this.cxboxCachingService.evictUserCache();
        return ResponseBuilder.build(additionalFieldsListResponse);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public void deleteAdditionalFields(@RequestBody RequestDTO<List<Long>> ids) {
        this.additionalFieldsService.deleteAdditionalFields((List)ids.getData());
        this.cxboxCachingService.evictUserCache();
    }

    @RequestMapping(method={RequestMethod.PUT})
    public ResponseDTO updateAdditionalFields(@RequestBody RequestDTO<List<AdditionalFieldsDTO>> requestDTO) {
        List<AdditionalFieldsDTO> additionalFieldsListResponse = this.additionalFieldsService.updateAdditionalFields((List)requestDTO.getData());
        this.cxboxCachingService.evictUserCache();
        return ResponseBuilder.build(additionalFieldsListResponse);
    }

    @ConstructorProperties(value={"additionalFieldsService", "cxboxCachingService"})
    @Generated
    public AdditionalFieldsController(AdditionalFieldsService additionalFieldsService, CxboxCachingService cxboxCachingService) {
        this.additionalFieldsService = additionalFieldsService;
        this.cxboxCachingService = cxboxCachingService;
    }
}

