/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cxbox.api.util.CxCollections;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.ChartMetaItem;
import org.springframework.stereotype.Component;

@Component
public class ChartFieldExtractor
implements FieldExtractor {
    private static Set<BcField> extractFromObject(WidgetDTO widget, JsonNode seriesNode) {
        return Stream.of("param", "value").map(name -> ChartFieldExtractor.extractField(widget, seriesNode, name)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<BcField> extractFromStringArray(WidgetDTO widget, JsonNode seriesNode) {
        return CxCollections.stream((Iterable)seriesNode).map(JsonNode::textValue).map(name -> ChartFieldExtractor.extractField(widget, seriesNode, name)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<BcField> extractFromObjectArray(WidgetDTO widget, JsonNode seriesNode) {
        HashSet<BcField> fields = new HashSet<BcField>();
        for (JsonNode jsonNode : seriesNode) {
            JsonNode dataNode = jsonNode.get("data");
            if (dataNode == null) continue;
            fields.addAll(Stream.of("categories", "param", "value", "section", "area", "name", "y", "drillDownTarget", "drillDownType").map(name -> ChartFieldExtractor.extractField(widget, dataNode, name)).flatMap(Collection::stream).collect(Collectors.toSet()));
            JsonNode valueNode = dataNode.get("value");
            if (valueNode == null || !valueNode.isArray()) continue;
            for (JsonNode value : valueNode) {
                fields.add(ChartFieldExtractor.newWidgetField(widget, value.get("value").textValue()));
            }
        }
        return fields;
    }

    private static Set<BcField> extractField(WidgetDTO widget, JsonNode node, String name) {
        JsonNode valueNode = node.get(name);
        if (valueNode != null && valueNode.isTextual()) {
            return Collections.singleton(ChartFieldExtractor.newWidgetField(widget, valueNode.textValue()));
        }
        return Collections.emptySet();
    }

    private static BcField newWidgetField(WidgetDTO widget, String name) {
        return new BcField(widget.getBcName(), ChartFieldExtractor.trim(name)).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName());
    }

    private static String trim(String value) {
        if (value.startsWith("%") && value.endsWith("%")) {
            return value.substring(1, value.length() - 1);
        }
        throw new IllegalArgumentException("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442");
    }

    private static JsonNode getJsonNode(JsonNode jsonNode, String ... path) {
        JsonNode currentNode = jsonNode;
        for (String s : path) {
            if ((currentNode = currentNode.get(s)) != null) continue;
            return null;
        }
        return currentNode;
    }

    @Override
    public Set<BcField> extract(WidgetDTO widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        JsonNode jsonNode = JsonUtils.readTree((String)widget.getChart());
        if (jsonNode.isArray()) {
            for (JsonNode chart : jsonNode) {
                String chartType;
                JsonNode seriesNode;
                if (chart == null) continue;
                JsonNode xAxisNode = ChartFieldExtractor.getJsonNode(chart, "meta", "xAxis");
                if (xAxisNode != null) {
                    fields.addAll(ChartFieldExtractor.extractField(widget, xAxisNode, "categories"));
                }
                if ((seriesNode = ChartFieldExtractor.getJsonNode(chart, "meta", "series")) == null) continue;
                JsonNode engineNode = ChartFieldExtractor.getJsonNode(chart, "engine");
                String engine = engineNode == null ? null : engineNode.textValue();
                JsonNode chartTypeNode = ChartFieldExtractor.getJsonNode(chart, "meta", "chart", "type");
                String string = chartType = chartTypeNode == null ? null : chartTypeNode.textValue();
                if ("List".equals(widget.getType()) || "DataGrid".equals(widget.getType())) {
                    if (ChartMetaItem.Engine.HIGHCHARTS.getValue().equals(engine)) {
                        if (chartType == null) {
                            fields.addAll(ChartFieldExtractor.extractFromObject(widget, seriesNode));
                            continue;
                        }
                        if ("pie".equals(chartType) || "pie-donut".equals(chartType)) {
                            fields.addAll(ChartFieldExtractor.extractFromObjectArray(widget, seriesNode));
                            continue;
                        }
                        fields.addAll(ChartFieldExtractor.extractFromStringArray(widget, seriesNode));
                        continue;
                    }
                    if (!ChartMetaItem.Engine.HIGHMAPS.getValue().equals(engine)) continue;
                    fields.addAll(ChartFieldExtractor.extractFromObjectArray(widget, seriesNode));
                    continue;
                }
                if (!"Pivot".equals(widget.getType()) || !ChartMetaItem.Engine.HIGHCHARTS.getValue().equals(engine)) continue;
                if (chartType == null) {
                    fields.addAll(ChartFieldExtractor.extractFromObject(widget, seriesNode));
                    continue;
                }
                if ("pie".equals(chartType) || "pie-donut".equals(chartType)) {
                    fields.addAll(ChartFieldExtractor.extractFromObjectArray(widget, seriesNode));
                    continue;
                }
                fields.addAll(ChartFieldExtractor.extractFromObject(widget, seriesNode));
            }
        }
        return fields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ChartFields");
        return result;
    }
}

