/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.MultivalueField;
import org.cxbox.meta.ui.model.PickListField;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.cxbox.meta.ui.model.json.field.subtypes.MultivalueFieldMeta;
import org.cxbox.meta.ui.model.json.field.subtypes.PickListFieldMeta;

public abstract class BaseFieldExtractor
implements FieldExtractor {
    private final LinkFieldExtractor linkFieldExtractor;

    protected BaseFieldExtractor(LinkFieldExtractor linkFieldExtractor) {
        this.linkFieldExtractor = linkFieldExtractor;
    }

    protected Set<BcField> extract(WidgetDTO widget, FieldMeta fieldMeta) {
        FieldMeta.FieldContainer fieldContainer;
        HashSet<BcField> widgetFields = new HashSet<BcField>();
        HashSet<BcField> pickListFields = new HashSet<BcField>();
        if (fieldMeta instanceof FieldMeta.FieldContainer && (fieldContainer = (FieldMeta.FieldContainer)((Object)fieldMeta)).getChildren() != null) {
            for (FieldMeta child : fieldContainer.getChildren()) {
                widgetFields.addAll(this.extract(widget, child));
            }
        }
        if (fieldMeta instanceof FieldMeta.FieldMetaBase) {
            FieldMeta.FieldMetaBase fieldMetaBase = (FieldMeta.FieldMetaBase)fieldMeta;
            for (PickListField pickList : this.getPickLists(fieldMetaBase)) {
                if (pickList.getPickMap() == null) continue;
                for (Map.Entry<String, String> entry : pickList.getPickMap().entrySet()) {
                    widgetFields.add(new BcField(widget.getBcName(), entry.getKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()));
                    pickListFields.add(new BcField(pickList.getPickListBc(), entry.getValue()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()).putAttribute(BcField.Attribute.PARENT_BC, widget.getBcName()).putAttribute(BcField.Attribute.PARENT_FIELD, entry.getKey()));
                }
            }
            widgetFields.addAll(this.extractFieldsFromMultiValue(widget, this.getMultivalueField(fieldMetaBase)));
            widgetFields.addAll(this.extractFieldsFromTitle(widget, LocalizationFormatter.i18n((String)fieldMetaBase.getTitle())));
            widgetFields.addAll(this.linkFieldExtractor.extract(widget, fieldMetaBase));
            if (fieldMetaBase.getMultisource() != null) {
                for (FieldMeta.FieldMetaBase.MultiSourceInfo multiSourceInfo : fieldMetaBase.getMultisource()) {
                    widgetFields.add(new BcField(widget.getBcName(), multiSourceInfo.getKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()));
                }
            }
            BcField widgetField = new BcField(widget.getBcName(), fieldMetaBase.getKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()).putAttribute(BcField.Attribute.TYPE, fieldMetaBase.getType()).putAttribute(BcField.Attribute.ICON_TYPE_KEY, fieldMetaBase.getIconTypeKey()).putAttribute(BcField.Attribute.HINT_KEY, fieldMetaBase.getHintKey()).putAttribute(BcField.Attribute.PICK_LIST_FIELDS, pickListFields);
            widgetFields.remove(widgetField);
            widgetFields.add(widgetField);
        }
        return widgetFields;
    }

    private List<BcField> extractFieldsFromMultiValue(WidgetDTO widget, MultivalueField multivalueField) {
        ArrayList<BcField> result = new ArrayList<BcField>();
        if (multivalueField == null) {
            return result;
        }
        if (multivalueField.getAssocValueKey() != null) {
            result.add(new BcField(multivalueField.getPopupBcName(), multivalueField.getAssocValueKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()));
        }
        if (multivalueField.getDisplayedKey() != null) {
            result.add(new BcField(widget.getBcName(), multivalueField.getDisplayedKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()));
        }
        return result;
    }

    private MultivalueField getMultivalueField(FieldMeta.FieldMetaBase field) {
        if (field.getType().equals("multivalue") || field.getType().equals("multivalueHover")) {
            MultivalueFieldMeta multivalueField = (MultivalueFieldMeta)field;
            return new MultivalueField(multivalueField.getPopupBcName(), multivalueField.getAssocValueKey(), multivalueField.getDisplayedKey(), multivalueField.getAssociateFieldKey());
        }
        return null;
    }

    @NonNull
    private List<PickListField> getPickLists(@NonNull FieldMeta.FieldMetaBase field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArrayList<PickListField> pickLists = new ArrayList<PickListField>();
        if (field instanceof PickListFieldMeta) {
            PickListFieldMeta pickListField = (PickListFieldMeta)field;
            pickLists.add(new PickListField(pickListField.getPopupBcName(), pickListField.getPickMap()));
        }
        return pickLists;
    }

    protected Set<BcField> extractFieldsFromTitle(WidgetDTO widget, String title) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (title == null) {
            return fields;
        }
        for (String fieldKey : this.fieldKeys(title)) {
            fields.add(new BcField(widget.getBcName(), fieldKey).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName()));
        }
        return fields;
    }

    @NonNull
    public List<String> fieldKeys(String template) {
        ArrayList<String> valueList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("[$][{](\\w+)}").matcher(template);
        while (matcher.find()) {
            String key = matcher.group(1);
            valueList.add(key);
        }
        return valueList;
    }
}

