/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.repository;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.meta.data.FilterGroupDTO;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.BcProperties;
import org.cxbox.meta.entity.BcProperties_;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.entity.FilterGroup_;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.entity.Responsibilities_;
import org.cxbox.meta.metahotreload.dto.BcSourceDTO;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.mapper.ScreenMapper;
import org.cxbox.meta.metahotreload.mapper.ViewMapper;
import org.cxbox.meta.metahotreload.service.MetaResourceReaderService;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class MetaRepository {
    private final JpaDao jpaDao;
    private final MetaResourceReaderService metaResourceReaderService;
    private final ScreenMapper screenMapper;
    private final ViewMapper viewMapper;

    public List<BcSourceDTO> getBcs() {
        return this.metaResourceReaderService.getBcs();
    }

    public void deleteAndSaveResponsibilities(List<Responsibilities> responsibilities) {
        this.jpaDao.delete(Responsibilities.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.saveAll(responsibilities);
    }

    public void deleteAllMeta() {
    }

    public Map<String, List<FilterGroupDTO>> getPersonalFilterGroups(IUser<Long> user) {
        return this.jpaDao.getList(FilterGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.isNotNull((Expression)root.get(FilterGroup_.bc)), (Expression)cb.equal((Expression)root.get(FilterGroup_.userId), (Object)String.valueOf(user.getId())))).stream().map(fg -> ((FilterGroupDTO.FilterGroupDTOBuilder)((FilterGroupDTO.FilterGroupDTOBuilder)((FilterGroupDTO.FilterGroupDTOBuilder)((FilterGroupDTO.FilterGroupDTOBuilder)((FilterGroupDTO.FilterGroupDTOBuilder)FilterGroupDTO.builder().bc(fg.getBc())).personal(Boolean.TRUE)).id(String.valueOf(fg.getId()))).name(fg.getName())).filters(fg.getFilters())).build()).collect(Collectors.groupingBy(FilterGroupDTO::getBc));
    }

    public Map<String, BcProperties> getBcProperties() {
        return this.jpaDao.getList(BcProperties.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(BcProperties_.bc))).stream().collect(Collectors.toMap(BcProperties::getBc, Function.identity()));
    }

    public Map<String, List<FilterGroup>> getFilterGroups() {
        return this.jpaDao.getList(FilterGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.isNotNull((Expression)root.get(FilterGroup_.bc)), (Expression)cb.isNull((Expression)root.get(FilterGroup_.userId)))).stream().collect(Collectors.groupingBy(FilterGroup::getBc));
    }

    public List<Responsibilities> getResponsibilityByUserAndRole(IUser<Long> user, LOV userRole, Responsibilities.ResponsibilityType responsibilityType) {
        return this.jpaDao.getList(Responsibilities.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(Responsibilities_.departmentId), user.getDepartmentId()), cb.equal((Expression)root.get(Responsibilities_.internalRoleCD), (Object)userRole), cb.equal((Expression)root.get(Responsibilities_.responsibilityType), (Object)responsibilityType)}));
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
    public Map<String, ScreenDTO> getAllScreens() {
        List<ScreenSourceDto> screens = this.metaResourceReaderService.getScreens();
        List<WidgetSourceDTO> widgets = this.metaResourceReaderService.getWidgets();
        List<ViewSourceDTO> views = this.metaResourceReaderService.getViews();
        Map<String, BcProperties> bcProps = this.getBcProperties();
        Map<String, List<FilterGroup>> filterGroups = this.getFilterGroups();
        Map<String, WidgetSourceDTO> widgetNameToWidget = widgets.stream().collect(Collectors.toMap(WidgetSourceDTO::getName, e -> e));
        Map<String, ViewDTO> viewNameToView = views.stream().map(v -> this.viewMapper.map((ViewSourceDTO)v, widgetNameToWidget)).collect(Collectors.toMap(ViewDTO::getName, e -> e));
        return screens.stream().map(screenSourceDto -> this.screenMapper.map((ScreenSourceDto)screenSourceDto, viewNameToView, bcProps, filterGroups)).collect(Collectors.toMap(ScreenDTO::getName, e -> e));
    }

    @ConstructorProperties(value={"jpaDao", "metaResourceReaderService", "screenMapper", "viewMapper"})
    @Generated
    public MetaRepository(JpaDao jpaDao, MetaResourceReaderService metaResourceReaderService, ScreenMapper screenMapper, ViewMapper viewMapper) {
        this.jpaDao = jpaDao;
        this.metaResourceReaderService = metaResourceReaderService;
        this.screenMapper = screenMapper;
        this.viewMapper = viewMapper;
    }
}

