/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.naming.OperationNotSupportedException;
import lombok.Generated;
import org.cxbox.meta.ui.field.CustomFields;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.PivotMeta;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldExtractor {
    private final Optional<CustomFields> customFields;

    public Set<BcField> extract(String widgetName, String bc, Object meta) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (!this.customFields.isPresent()) {
            return fields;
        }
        CustomFields service = this.customFields.get();
        Map<Object, Object> custom = new HashMap();
        if (meta instanceof FieldMeta.FieldMetaBase) {
            custom = ((FieldMeta.FieldMetaBase)meta).getCustomFields();
        } else if (meta instanceof PivotMeta.TableColRow) {
            throw new OperationNotSupportedException("meta type PivotMeta is not supported");
        }
        List<String> fieldNames = service.getFieldNames();
        for (Map.Entry<Object, Object> entry : custom.entrySet()) {
            if (!fieldNames.contains(entry.getKey())) {
                throw new IllegalArgumentException("Not found field with key:" + (String)entry.getKey());
            }
            fields.add(new BcField(bc, (String)entry.getValue()).putAttribute(BcField.Attribute.WIDGET_NAME, widgetName));
        }
        return fields;
    }

    @ConstructorProperties(value={"customFields"})
    @Generated
    public CustomFieldExtractor(Optional<CustomFields> customFields) {
        this.customFields = customFields;
    }
}

