/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.BaseFieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.field.FieldGroup;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormFieldExtractor
extends BaseFieldExtractor {
    public FormFieldExtractor(@Autowired LinkFieldExtractor linkFieldExtractor) {
        super(linkFieldExtractor);
    }

    @Override
    public Set<BcField> extract(WidgetDTO widget) {
        HashSet<BcField> widgetFields = new HashSet<BcField>(this.extractFieldsFromTitle(widget, LocalizationFormatter.i18n((String)widget.getTitle())));
        for (FieldGroup group : (FieldGroup[])JsonUtils.readValue(FieldGroup[].class, (String)widget.getFields())) {
            if (group.getChildren() == null) continue;
            for (FieldMeta field : group.getChildren()) {
                widgetFields.addAll(this.extract(widget, field));
            }
        }
        return widgetFields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Info");
        result.add("InfoFloat");
        result.add("Form");
        return result;
    }
}

