/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.filterGroup;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.cxbox.core.config.cache.CxboxCachingService;
import org.cxbox.core.dto.RequestDTO;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.util.ResponseBuilder;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.meta.data.FilterGroupDTO;
import org.cxbox.meta.data.FilterGroupDTOList;
import org.cxbox.meta.filterGroup.PersonalFilterGroupService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}/personalFilterGroups"})
public class PersonalFilterGroupsController {
    private final PersonalFilterGroupService personalFilterGroupService;
    private final CxboxCachingService cxboxCachingService;
    private final SessionService sessionService;

    @PostMapping
    public ResponseDTO createFilterGroup(@RequestBody RequestDTO<FilterGroupDTOList> request) {
        List<FilterGroupDTO> filterGroupDTOResponse = this.personalFilterGroupService.create(((FilterGroupDTOList)request.getData()).getFilterGroups());
        this.cxboxCachingService.evictUserCache();
        return ResponseBuilder.build(filterGroupDTOResponse);
    }

    @DeleteMapping
    public void deleteFilterGroup(@RequestBody List<Long> ids) {
        this.personalFilterGroupService.delete(ids);
        this.cxboxCachingService.evictUserCache();
    }

    @ConstructorProperties(value={"personalFilterGroupService", "cxboxCachingService", "sessionService"})
    @Generated
    public PersonalFilterGroupsController(PersonalFilterGroupService personalFilterGroupService, CxboxCachingService cxboxCachingService, SessionService sessionService) {
        this.personalFilterGroupService = personalFilterGroupService;
        this.cxboxCachingService = cxboxCachingService;
        this.sessionService = sessionService;
    }
}

