/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field.link;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.Generated;
import org.cxbox.core.util.InstrumentationAwareReflectionUtils;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.CustomFieldExtractor;
import org.cxbox.meta.ui.field.link.LinkToField;
import org.cxbox.meta.ui.model.BcField;
import org.springframework.stereotype.Component;

@Component
public final class LinkFieldExtractor {
    private final CustomFieldExtractor customFieldExtractor;

    public Set<BcField> extract(WidgetDTO widget, Object object) {
        return this.extract(widget.getName(), widget.getBcName(), object);
    }

    public Set<BcField> extract(String widgetName, String bc, Object object) {
        HashSet<BcField> fields = new HashSet<BcField>();
        AtomicInteger maxDepth = new AtomicInteger(5);
        LinkFieldExtractor.recursiveExtractLinkToFields(widgetName, bc, object, fields, maxDepth);
        Set<BcField> customFields = this.customFieldExtractor.extract(widgetName, bc, object);
        fields.addAll(customFields);
        return fields;
    }

    private static void recursiveExtractLinkToFields(String widgetName, String bc, @Nullable Object object, Set<BcField> fields, AtomicInteger depth) throws IllegalAccessException {
        if (object == null) {
            return;
        }
        if (depth.decrementAndGet() <= 0) {
            return;
        }
        for (Field field : InstrumentationAwareReflectionUtils.getAllNonSyntheticFieldsList(object.getClass())) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(LinkToField.class) && field.get(object) != null) {
                fields.add(new BcField(bc, (String)field.get(object)).putAttribute(BcField.Attribute.WIDGET_NAME, widgetName));
                continue;
            }
            LinkFieldExtractor.recursiveExtractLinkToFields(widgetName, bc, field.get(object), fields, depth);
        }
    }

    @ConstructorProperties(value={"customFieldExtractor"})
    @Generated
    public LinkFieldExtractor(CustomFieldExtractor customFieldExtractor) {
        this.customFieldExtractor = customFieldExtractor;
    }
}

