/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metafieldsecurity;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.ExtendedDtoFieldLevelSecurityService;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.bc.InnerBcTypeAware;
import org.cxbox.core.controller.BcHierarchyAware;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.service.DTOSecurityUtils;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.metafieldsecurity.WidgetUtils;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.ui.field.IRequiredFieldsSupplier;
import org.cxbox.meta.ui.model.BcField;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class BcUtils
implements ExtendedDtoFieldLevelSecurityService {
    private final InnerBcTypeAware innerBcTypeAware;
    private final MetaRepository metaRepository;
    private final WidgetUtils widgetUtils;
    private final BcRegistry bcRegistry;
    private final DTOSecurityUtils dtoSecurityUtils;
    private final BcHierarchyAware bcHierarchyAware;
    private final ResponsibilitiesService responsibilitiesService;
    private final SessionService sessionService;
    private final Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers;
    private final ViewFieldsCache viewFieldsCache;

    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFields(BcIdentifier bcIdentifier) {
        BcDescription bcDescription = this.bcRegistry.getBcDescription(bcIdentifier.getName());
        if (bcDescription instanceof InnerBcDescription) {
            InnerBcDescription innerBcDescription = (InnerBcDescription)bcDescription;
            try {
                Class dtoClass = this.innerBcTypeAware.getTypeOfDto(innerBcDescription);
                return this.dtoSecurityUtils.getDtoFields(dtoClass);
            }
            catch (RuntimeException e) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #bc.name}")
    public Set<String> getBcFieldsForCurrentScreen(BcIdentifier bc) {
        HashSet<String> viewFields = new HashSet<String>();
        for (String viewName : this.getCurrentScreenViews()) {
            Set fields = this.viewFieldsCache.getDtoFieldsAvailableOnCurrentView(viewName).getOrDefault(bc.getName(), Collections.emptySet());
            for (BcField field : fields) {
                viewFields.add(field.getName());
            }
        }
        return viewFields;
    }

    public Collection<String> getCurrentScreenViews() {
        return this.getViews(this.bcHierarchyAware.getScreenName());
    }

    public List<String> getViews(String screenName) {
        return this.responsibilitiesService.getAvailableScreenViews(screenName, this.sessionService.getSessionUser(), this.sessionService.getSessionUserRole());
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #bc.name}")
    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFieldsAvailableOnCurrentScreen(BcIdentifier bc) {
        Set<String> viewFields = this.getBcFieldsForCurrentScreen(bc);
        return this.getDtoFields(bc).stream().filter(field -> viewFields.contains(field.getName())).map(field -> field).collect(Collectors.toSet());
    }

    @Generated
    public InnerBcTypeAware getInnerBcTypeAware() {
        return this.innerBcTypeAware;
    }

    @Generated
    public MetaRepository getMetaRepository() {
        return this.metaRepository;
    }

    @Generated
    public WidgetUtils getWidgetUtils() {
        return this.widgetUtils;
    }

    @Generated
    public BcRegistry getBcRegistry() {
        return this.bcRegistry;
    }

    @Generated
    public DTOSecurityUtils getDtoSecurityUtils() {
        return this.dtoSecurityUtils;
    }

    @Generated
    public BcHierarchyAware getBcHierarchyAware() {
        return this.bcHierarchyAware;
    }

    @Generated
    public ResponsibilitiesService getResponsibilitiesService() {
        return this.responsibilitiesService;
    }

    @Generated
    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Generated
    public Optional<List<IRequiredFieldsSupplier>> getRequiredFieldsSuppliers() {
        return this.requiredFieldsSuppliers;
    }

    @Generated
    public ViewFieldsCache getViewFieldsCache() {
        return this.viewFieldsCache;
    }

    @ConstructorProperties(value={"innerBcTypeAware", "metaRepository", "widgetUtils", "bcRegistry", "dtoSecurityUtils", "bcHierarchyAware", "responsibilitiesService", "sessionService", "requiredFieldsSuppliers", "viewFieldsCache"})
    @Generated
    public BcUtils(InnerBcTypeAware innerBcTypeAware, MetaRepository metaRepository, WidgetUtils widgetUtils, BcRegistry bcRegistry, DTOSecurityUtils dtoSecurityUtils, BcHierarchyAware bcHierarchyAware, ResponsibilitiesService responsibilitiesService, SessionService sessionService, Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers, ViewFieldsCache viewFieldsCache) {
        this.innerBcTypeAware = innerBcTypeAware;
        this.metaRepository = metaRepository;
        this.widgetUtils = widgetUtils;
        this.bcRegistry = bcRegistry;
        this.dtoSecurityUtils = dtoSecurityUtils;
        this.bcHierarchyAware = bcHierarchyAware;
        this.responsibilitiesService = responsibilitiesService;
        this.sessionService = sessionService;
        this.requiredFieldsSuppliers = requiredFieldsSuppliers;
        this.viewFieldsCache = viewFieldsCache;
    }

    @Component
    public static class ViewFieldsCache {
        final MetaRepository metaRepository;
        final WidgetUtils widgetUtils;
        final Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.targetClass, #root.methodName, #viewName}")
        public Map<String, Set<BcField>> getDtoFieldsAvailableOnCurrentView(String viewName) {
            HashSet fields = new HashSet();
            this.metaRepository.getAllScreens().forEach((name, screen) -> screen.getViews().forEach(view -> {
                if (Objects.equals(view.getName(), viewName)) {
                    view.getWidgets().forEach(widget -> {
                        HashSet<BcField> widgetFields = new HashSet<BcField>(this.widgetUtils.extractAllFields((WidgetDTO)widget));
                        widgetFields.stream().map(BcField::getBc).filter(Objects::nonNull).forEach(bc -> fields.addAll(this.getRequiredBcFields((String)bc)));
                        fields.addAll(widgetFields);
                    });
                }
            }));
            return fields.stream().collect(Collectors.groupingBy(BcField::getBc, Collectors.toSet()));
        }

        @NonNull
        public Set<BcField> getRequiredBcFields(@NonNull String bc) {
            if (bc == null) {
                throw new NullPointerException("bc is marked non-null but is null");
            }
            HashSet<BcField> fields = new HashSet<BcField>();
            this.requiredFieldsSuppliers.ifPresent(suppliers -> suppliers.forEach(supplier -> fields.addAll(supplier.getRequiredFields(bc))));
            return fields;
        }

        @ConstructorProperties(value={"metaRepository", "widgetUtils", "requiredFieldsSuppliers"})
        @Generated
        public ViewFieldsCache(MetaRepository metaRepository, WidgetUtils widgetUtils, Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers) {
            this.metaRepository = metaRepository;
            this.widgetUtils = widgetUtils;
            this.requiredFieldsSuppliers = requiredFieldsSuppliers;
        }
    }
}

