/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metafieldsecurity;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.springframework.stereotype.Component;

@Component
public final class WidgetUtils {
    private final Map<String, FieldExtractor> fieldExtractorMap;

    public WidgetUtils(List<FieldExtractor> fieldExtractors) {
        HashMap extractors = new HashMap();
        fieldExtractors.forEach(extractor -> extractor.getSupportedTypes().forEach(type -> extractors.compute(type, (key, current) -> Stream.of(current, extractor).filter(Objects::nonNull).min(Comparator.comparing(FieldExtractor::getPriority)).orElse((FieldExtractor)extractor))));
        this.fieldExtractorMap = Collections.unmodifiableMap(extractors);
    }

    public Set<BcField> extractFields(WidgetDTO widget) {
        FieldExtractor fieldExtractor = this.fieldExtractorMap.get(widget.getType());
        if (fieldExtractor == null) {
            return Collections.emptySet();
        }
        return fieldExtractor.extract(widget);
    }

    public Set<BcField> extractPickListFields(WidgetDTO widget) {
        return this.extractFields(widget).stream().map(field -> (Set)field.getAttribute(BcField.Attribute.PICK_LIST_FIELDS)).filter(e -> e != null && !e.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<BcField> extractShowConditionFields(WidgetDTO widget) {
        return this.fieldExtractorMap.get("ShowConditionFields").extract(widget);
    }

    public Set<BcField> extractPivotFields(WidgetDTO widget) {
        return this.fieldExtractorMap.get("PivotFields").extract(widget);
    }

    public Set<BcField> extractChartFields(WidgetDTO widget) {
        return this.fieldExtractorMap.get("ChartFields").extract(widget);
    }

    public Set<BcField> extractHierarchyFields(WidgetDTO widget) {
        return this.fieldExtractorMap.get("HierarchyFields").extract(widget);
    }

    public Set<BcField> extractAllFields(WidgetDTO widget) {
        HashSet<BcField> fields = new HashSet<BcField>(this.extractFields(widget));
        fields.addAll(this.extractShowConditionFields(widget));
        fields.addAll(this.extractPivotFields(widget));
        fields.addAll(this.extractChartFields(widget));
        fields.addAll(this.extractHierarchyFields(widget));
        fields.addAll(fields.stream().map(field -> (Set)field.getAttribute(BcField.Attribute.PICK_LIST_FIELDS)).filter(e -> e != null && !e.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet()));
        return fields;
    }
}

