/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.MetaHotReloadService;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.service.MetaResourceReaderService;

public class MetaHotReloadServiceImpl
implements MetaHotReloadService {
    protected final MetaConfigurationProperties config;
    protected final MetaResourceReaderService metaResourceReaderService;
    protected final InternalAuthorizationService authzService;
    protected final TransactionService txService;
    protected final MetaRepository metaRepository;

    public void loadMeta() {
        List<ScreenSourceDto> screenDtos = this.metaResourceReaderService.getScreens();
        List<ViewSourceDTO> viewDtos = this.metaResourceReaderService.getViews();
        this.authzService.loginAs(this.authzService.createAuthentication(InternalAuthorizationService.VANILLA));
        this.txService.invokeInTx(() -> {
            this.metaRepository.deleteAllMeta();
            this.responsibilitiesProcess(screenDtos, viewDtos);
            this.loadMetaAfterProcess();
            return null;
        });
    }

    public void responsibilitiesProcess(List<ScreenSourceDto> screenDtos, List<ViewSourceDTO> viewDtos) {
        if (this.config.isViewAllowedRolesEnabled()) {
            HashMap viewToScreenMap = new HashMap();
            this.metaRepository.getAllScreens().forEach((screenName, screenDto) -> screenDto.getViews().stream().map(ViewDTO::getName).forEach(viewName -> viewToScreenMap.put(viewName, screenName)));
            ArrayList<Responsibilities> responsibilities = new ArrayList<Responsibilities>();
            long defaultDepartmentId = 0L;
            viewDtos.forEach(view -> view.getRolesAllowed().forEach(role -> responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.VIEW).setInternalRoleCD(new LOV(role)).setView(view.getName()).setDepartmentId(defaultDepartmentId))));
            Map<String, ScreenSourceDto> screenNameToScreen = screenDtos.stream().collect(Collectors.toMap(ScreenSourceDto::getName, sd -> sd));
            HashMap rolesToScreens = new HashMap();
            viewDtos.forEach(v -> {
                if (viewToScreenMap.containsKey(v.getName())) {
                    String screenName = (String)viewToScreenMap.get(v.getName());
                    v.getRolesAllowed().forEach(role -> {
                        if (!rolesToScreens.containsKey(role)) {
                            rolesToScreens.put(role, new HashSet());
                        }
                        ((Set)rolesToScreens.get(role)).add((ScreenSourceDto)screenNameToScreen.get(screenName));
                    });
                }
            });
            for (Map.Entry entry : rolesToScreens.entrySet()) {
                String role = (String)entry.getKey();
                Set screens = (Set)entry.getValue();
                responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.SCREEN).setInternalRoleCD(new LOV(role)).setScreens(this.mapToScreens(screens)).setDepartmentId(defaultDepartmentId));
            }
            this.metaRepository.deleteAndSaveResponsibilities(responsibilities);
        }
    }

    @NonNull
    public String mapToScreens(@NonNull Set<ScreenSourceDto> screens) {
        if (screens == null) {
            throw new NullPointerException("screens is marked non-null but is null");
        }
        StringJoiner joiner = new StringJoiner(",");
        List orderedScreens = screens.stream().sorted(Comparator.comparing(ScreenSourceDto::getOrder).thenComparing(ScreenSourceDto::getName)).collect(Collectors.toList());
        for (int i = 0; i < orderedScreens.size(); ++i) {
            ScreenSourceDto screen = (ScreenSourceDto)orderedScreens.get(i);
            String s = "  {\n    \"id\": \"id" + i + "\",\n    \"name\": \"" + screen.getName() + "\",\n    \"text\": \"" + screen.getTitle() + "\",\n    \"url\": \"/screen/" + screen.getName() + "\",\n    \"icon\": \"" + screen.getIcon() + "\"\n  }";
            joiner.add(s);
        }
        String collect = joiner.toString();
        return "[\n" + collect + "\n]";
    }

    protected void loadMetaAfterProcess() {
    }

    @ConstructorProperties(value={"config", "metaResourceReaderService", "authzService", "txService", "metaRepository"})
    @Generated
    public MetaHotReloadServiceImpl(MetaConfigurationProperties config, MetaResourceReaderService metaResourceReaderService, InternalAuthorizationService authzService, TransactionService txService, MetaRepository metaRepository) {
        this.config = config;
        this.metaResourceReaderService = metaResourceReaderService;
        this.authzService = authzService;
        this.txService = txService;
        this.metaRepository = metaRepository;
    }
}

