/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.cxbox.core.config.properties.WidgetFieldsIdResolverProperties;
import org.cxbox.meta.ui.field.CxboxWidgetField;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class PackageScanFieldIdResolver
implements TypeIdResolver {
    private final Map<String, JavaType> typeMap = new HashMap<String, JavaType>();
    private final WidgetFieldsIdResolverProperties widgetFieldsIdResolverProperties;

    public void init(JavaType javaType) {
        String[] includePackages = this.widgetFieldsIdResolverProperties.getIncludePackages();
        String[] excludeClasses = this.widgetFieldsIdResolverProperties.getExcludeClasses();
        Class baseClazz = javaType.getRawClass();
        Set<Class<?>> fieldsClasses = this.scanForFields(includePackages);
        fieldsClasses.forEach(annotatedClazz -> {
            if (!Arrays.asList(excludeClasses).contains(annotatedClazz.getCanonicalName())) {
                if (!baseClazz.isAssignableFrom((Class<?>)annotatedClazz)) {
                    throw new IllegalStateException("Class " + annotatedClazz.getName() + ", annotated with " + CxboxWidgetField.class.getName() + " must extends from class " + baseClazz.getName());
                }
                CxboxWidgetField cxboxWidgetField = annotatedClazz.getAnnotation(CxboxWidgetField.class);
                for (String widgetType : cxboxWidgetField.value()) {
                    if (this.typeMap.containsKey(widgetType)) {
                        throw new IllegalStateException("Widget type \"" + widgetType + "\" dublicated in CxboxWidgetField annotations.");
                    }
                    this.typeMap.put(widgetType, TypeFactory.defaultInstance().constructSpecializedType(javaType, annotatedClazz));
                }
            }
        });
    }

    private Set<Class<?>> scanForFields(String[] packages) {
        if (packages.length == 0) {
            return Collections.emptySet();
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(CxboxWidgetField.class));
        HashSet entitySet = new HashSet();
        for (String basePackage : packages) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                try {
                    entitySet.add(ClassUtils.forName((String)Objects.requireNonNull(candidate.getBeanClassName()), (ClassLoader)this.getClass().getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return entitySet;
    }

    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    public String idFromBaseType() {
        return null;
    }

    public String idFromValueAndType(Object o, Class<?> aClass) {
        if (o instanceof FieldMeta.FieldMetaBase && this.typeMap.containsKey(((FieldMeta.FieldMetaBase)o).getType())) {
            return this.typeMap.get(((FieldMeta.FieldMetaBase)o).getType()).getRawClass().getSimpleName();
        }
        return null;
    }

    public JavaType typeFromId(DatabindContext databindContext, String s) throws IOException {
        if (this.typeMap.containsKey(s)) {
            return this.typeMap.get(s);
        }
        throw new IOException("Cannot find class for type = \"" + s + "\"");
    }

    public String getDescForKnownTypeIds() {
        return null;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @ConstructorProperties(value={"widgetFieldsIdResolverProperties"})
    @Generated
    public PackageScanFieldIdResolver(WidgetFieldsIdResolverProperties widgetFieldsIdResolverProperties) {
        this.widgetFieldsIdResolverProperties = widgetFieldsIdResolverProperties;
    }
}

