/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.entity;

import java.beans.ConstructorProperties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.entity.BaseEntity;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Type;

@Entity
@Table(name="NOTIFICATION")
public class Notification
extends BaseEntity {
    @Column(name="SUBJECT")
    private String subject;
    @Column(name="UI_SUBJECT")
    private String uiSubject;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="MESSAGE")
    private String message;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="UI_MESSAGE")
    private String uiMessage;
    @Formula(value="BITAND(DELIVERY_STATUS, 1)")
    private Integer readBit;
    @Formula(value="BITAND(DELIVERY_TYPE, 1)")
    private Integer pushBit;
    @Column(name="URL")
    private String url;
    @Column(name="USER_ID", nullable=false)
    private Long recipientId;
    @Column(name="DELIVERY_TYPE")
    private int deliveryType;
    @Column(name="DELIVERY_STATUS")
    private int deliveryStatus;
    @Column(name="MIME_TYPE_CD")
    private LOV mimeType;
    @Column(name="EVENT_NAME_CD")
    private LOV eventName;

    @PreUpdate
    @PrePersist
    public final void prePersist() {
        this.subject = StringUtils.truncate((String)this.subject, (int)1500);
        this.uiSubject = StringUtils.truncate((String)this.uiSubject, (int)1500);
    }

    @Transient
    public boolean isRead() {
        return this.readBit == 1;
    }

    @Transient
    public boolean isPush() {
        return this.pushBit == 1;
    }

    @Generated
    public static NotificationBuilder builder() {
        return new NotificationBuilder();
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setUiSubject(String uiSubject) {
        this.uiSubject = uiSubject;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setUiMessage(String uiMessage) {
        this.uiMessage = uiMessage;
    }

    @Generated
    public void setReadBit(Integer readBit) {
        this.readBit = readBit;
    }

    @Generated
    public void setPushBit(Integer pushBit) {
        this.pushBit = pushBit;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setRecipientId(Long recipientId) {
        this.recipientId = recipientId;
    }

    @Generated
    public void setDeliveryType(int deliveryType) {
        this.deliveryType = deliveryType;
    }

    @Generated
    public void setDeliveryStatus(int deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    @Generated
    public void setMimeType(LOV mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public void setEventName(LOV eventName) {
        this.eventName = eventName;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getUiSubject() {
        return this.uiSubject;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getUiMessage() {
        return this.uiMessage;
    }

    @Generated
    public Integer getReadBit() {
        return this.readBit;
    }

    @Generated
    public Integer getPushBit() {
        return this.pushBit;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Long getRecipientId() {
        return this.recipientId;
    }

    @Generated
    public int getDeliveryType() {
        return this.deliveryType;
    }

    @Generated
    public int getDeliveryStatus() {
        return this.deliveryStatus;
    }

    @Generated
    public LOV getMimeType() {
        return this.mimeType;
    }

    @Generated
    public LOV getEventName() {
        return this.eventName;
    }

    @ConstructorProperties(value={"subject", "uiSubject", "message", "uiMessage", "readBit", "pushBit", "url", "recipientId", "deliveryType", "deliveryStatus", "mimeType", "eventName"})
    @Generated
    public Notification(String subject, String uiSubject, String message, String uiMessage, Integer readBit, Integer pushBit, String url, Long recipientId, int deliveryType, int deliveryStatus, LOV mimeType, LOV eventName) {
        this.subject = subject;
        this.uiSubject = uiSubject;
        this.message = message;
        this.uiMessage = uiMessage;
        this.readBit = readBit;
        this.pushBit = pushBit;
        this.url = url;
        this.recipientId = recipientId;
        this.deliveryType = deliveryType;
        this.deliveryStatus = deliveryStatus;
        this.mimeType = mimeType;
        this.eventName = eventName;
    }

    @Generated
    public Notification() {
    }

    @Generated
    public static class NotificationBuilder {
        @Generated
        private String subject;
        @Generated
        private String uiSubject;
        @Generated
        private String message;
        @Generated
        private String uiMessage;
        @Generated
        private Integer readBit;
        @Generated
        private Integer pushBit;
        @Generated
        private String url;
        @Generated
        private Long recipientId;
        @Generated
        private int deliveryType;
        @Generated
        private int deliveryStatus;
        @Generated
        private LOV mimeType;
        @Generated
        private LOV eventName;

        @Generated
        NotificationBuilder() {
        }

        @Generated
        public NotificationBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public NotificationBuilder uiSubject(String uiSubject) {
            this.uiSubject = uiSubject;
            return this;
        }

        @Generated
        public NotificationBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public NotificationBuilder uiMessage(String uiMessage) {
            this.uiMessage = uiMessage;
            return this;
        }

        @Generated
        public NotificationBuilder readBit(Integer readBit) {
            this.readBit = readBit;
            return this;
        }

        @Generated
        public NotificationBuilder pushBit(Integer pushBit) {
            this.pushBit = pushBit;
            return this;
        }

        @Generated
        public NotificationBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public NotificationBuilder recipientId(Long recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        @Generated
        public NotificationBuilder deliveryType(int deliveryType) {
            this.deliveryType = deliveryType;
            return this;
        }

        @Generated
        public NotificationBuilder deliveryStatus(int deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Generated
        public NotificationBuilder mimeType(LOV mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Generated
        public NotificationBuilder eventName(LOV eventName) {
            this.eventName = eventName;
            return this;
        }

        @Generated
        public Notification build() {
            return new Notification(this.subject, this.uiSubject, this.message, this.uiMessage, this.readBit, this.pushBit, this.url, this.recipientId, this.deliveryType, this.deliveryStatus, this.mimeType, this.eventName);
        }

        @Generated
        public String toString() {
            return "Notification.NotificationBuilder(subject=" + this.subject + ", uiSubject=" + this.uiSubject + ", message=" + this.message + ", uiMessage=" + this.uiMessage + ", readBit=" + this.readBit + ", pushBit=" + this.pushBit + ", url=" + this.url + ", recipientId=" + this.recipientId + ", deliveryType=" + this.deliveryType + ", deliveryStatus=" + this.deliveryStatus + ", mimeType=" + this.mimeType + ", eventName=" + this.eventName + ")";
        }
    }
}

