/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.cxbox.api.data.dao.databaselistener.IChangeListener;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.AsyncService;
import org.cxbox.api.service.ObjectLoader;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.model.core.api.CurrentUserAware;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.User;
import org.cxbox.notifications.api.EventSettings;
import org.cxbox.notifications.api.INotificationTemplate;
import org.cxbox.notifications.api.NotificationEvent;
import org.cxbox.notifications.api.NotificationSettingsProvider;
import org.cxbox.notifications.api.NotificationTemplateSupport;
import org.cxbox.notifications.api.Recipient;
import org.cxbox.notifications.model.api.EventRecipientInterceptor;
import org.cxbox.notifications.model.api.INotificationEventBuilder;
import org.cxbox.notifications.model.api.IRecipientResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractEventGenerator<E extends BaseEntity>
implements IChangeListener<E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventGenerator.class);
    @Autowired
    private JpaDao jpaDao;
    @Autowired
    protected ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private CurrentUserAware<User> currentUserAware;
    @Autowired
    private NotificationTemplateSupport templateSupport;
    @Autowired
    private NotificationSettingsProvider notificationSettingsProvider;
    @Autowired
    private List<ObjectLoader> loaders;
    @Autowired
    private TransactionService txService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private Optional<List<EventRecipientInterceptor>> deliveryInterceptors;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void publish(NotificationEvent event) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    private boolean isSendAsync() {
        return this.deliveryInterceptors.map(list -> list.stream().anyMatch(EventRecipientInterceptor::isSendAsync)).orElse(false);
    }

    private boolean isCurrentUserAction() {
        return this.deliveryInterceptors.map(list -> list.stream().anyMatch(EventRecipientInterceptor::isCurrentUserAction)).orElse(false);
    }

    protected final NotificationEvent createEvent(LOV eventName) {
        return new NotificationEvent(this).setEvent(eventName);
    }

    protected Map<LOV, IRecipientResolver<E>> getRecipientResolvers() {
        return Collections.emptyMap();
    }

    private List<User> getRecipients(E entity, LOV event, LOV recipientRole) {
        IRecipientResolver<E> provider = this.getRecipientResolvers().get(recipientRole);
        if (provider == null) {
            return Collections.emptyList();
        }
        return provider.getRecipients(entity, event);
    }

    protected User getPerformer() {
        return this.getPerformer(null);
    }

    protected User getPerformer(E entity) {
        if (entity == null) {
            return (User)this.currentUserAware.getCurrentUser();
        }
        Long author = entity.getLastUpdBy();
        if (author != null) {
            return (User)this.jpaDao.findById(User.class, author);
        }
        author = entity.getCreatedBy();
        if (author != null) {
            return (User)this.jpaDao.findById(User.class, author);
        }
        return (User)this.currentUserAware.getCurrentUser();
    }

    public static class DefaultBuilder
    implements INotificationEventBuilder {
        protected final E entity;
        protected final LOV event;
        protected Map<String, Object> model = new HashMap<String, Object>();
        protected List<User> excludeUsers = new ArrayList<User>();
        private LOV mimeType;
        private Map<User, Set<LOV>> recipients = new HashMap<User, Set<LOV>>();
        private boolean defaultRecipients = true;
        final /* synthetic */ AbstractEventGenerator this$0;

        public DefaultBuilder(E entity, LOV event) {
            this.this$0 = this$0;
            this.entity = (BaseEntity)this.ensureLoaded(entity);
            this.event = event;
        }

        @Override
        public INotificationEventBuilder setMimeType(LOV mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public INotificationEventBuilder addDefaultRecipients(boolean value) {
            this.defaultRecipients = value;
            return null;
        }

        @Override
        public INotificationEventBuilder addRecipients(LOV recipientRole, Collection<User> users) {
            users.stream().filter(Objects::nonNull).forEach(user -> this.addRecipient(recipientRole, (User)user));
            return this;
        }

        @Override
        public INotificationEventBuilder addRecipient(LOV recipientRole) {
            this.addRecipients(recipientRole, this.this$0.getRecipients(this.entity, this.event, recipientRole));
            return this;
        }

        @Override
        public INotificationEventBuilder addRecipient(LOV recipientRole, User user) {
            this.recipients.computeIfAbsent(this.ensureLoaded(user), k -> new HashSet()).add(recipientRole);
            return this;
        }

        @Override
        public INotificationEventBuilder addModel(String name, Object value) {
            if (value != null) {
                this.model.put(name, this.ensureLoaded(value));
            }
            return this;
        }

        @Override
        public INotificationEventBuilder addModel(Map<String, Object> model) {
            model.forEach(this::addModel);
            return this;
        }

        @Override
        public INotificationEventBuilder setPerformer(User user) {
            this.addModel("performer", user);
            return this;
        }

        @Override
        public INotificationEventBuilder excludeUser(User user) {
            if (user != null) {
                this.excludeUsers.add(user);
            }
            return this;
        }

        @Override
        public INotificationEventBuilder excludePerformer() {
            return this.excludeUser(this.this$0.getPerformer());
        }

        @Override
        public void publish() {
            this.publish(this.this$0.isSendAsync());
        }

        @Override
        public final void publish(boolean async) {
            boolean isCurrentUserAction = this.this$0.isCurrentUserAction();
            Invoker invoker = Invoker.of(() -> this.doPublish(isCurrentUserAction));
            if (async) {
                this.this$0.asyncService.invokeAsync(() -> (Void)this.this$0.txService.invokeInTx(invoker));
            } else {
                invoker.invoke();
            }
        }

        private Map<String, Object> getModelFor(User recipient, Set<LOV> recipientRoles) {
            return ImmutableMap.builder().put((Object)"entity", this.entity).put((Object)"recipient", (Object)recipient).put((Object)"recipient_roles", recipientRoles).putAll(this.model).build();
        }

        private void doPublish(boolean isCurrentUserAction) {
            if (this.entity == null) {
                return;
            }
            EventSettings settings = this.this$0.notificationSettingsProvider.getGlobalSettings(this.event);
            if (settings == null) {
                return;
            }
            INotificationTemplate template = this.this$0.templateSupport.getTemplate(this.event);
            if (template == null && this.this$0.templateSupport.isTemplateRequired(this.model)) {
                return;
            }
            if (this.defaultRecipients) {
                for (Recipient recipient2 : settings.getRecipients()) {
                    this.addRecipients(recipient2.getRole(), this.this$0.getRecipients(this.entity, this.event, recipient2.getRole()));
                }
            }
            if (this.recipients.isEmpty()) {
                return;
            }
            this.recipients.forEach((recipient, roles) -> {
                NotificationEvent event;
                if (recipient != null && roles != null && !roles.isEmpty() && (event = this.buildNotificationEvent(settings, template, (User)recipient, (Set<LOV>)roles, isCurrentUserAction)) != null) {
                    this.this$0.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                }
            });
        }

        private NotificationEvent buildNotificationEvent(EventSettings globalSettings, INotificationTemplate template, User user, Set<LOV> roles, boolean userLess) {
            int deliveryType = this.getDeliveryType(globalSettings, user, roles, userLess);
            if (deliveryType <= 0) {
                return null;
            }
            Map<String, Object> data = this.getModelFor(user, roles);
            NotificationEvent notificationEvent = this.this$0.createEvent(this.event);
            notificationEvent.setDeliveryType(deliveryType);
            notificationEvent.setRecipientId(user.getId());
            notificationEvent.setMimeType(this.getMimeType(template));
            return this.this$0.templateSupport.processTemplate(template, data, notificationEvent);
        }

        private LOV getMimeType(INotificationTemplate template) {
            if (this.mimeType != null) {
                return this.mimeType;
            }
            if (template != null) {
                return template.getMimeType();
            }
            return CoreDictionaries.MimeType.TEXT;
        }

        private int getDeliveryType(EventSettings globalSettings, User user, Set<LOV> recipientRoles, boolean isCurrentUserAction) {
            this.this$0.deliveryInterceptors.ifPresent(list -> list.forEach(interceptor -> interceptor.modifyRoles(globalSettings, recipientRoles, user)));
            if (recipientRoles.isEmpty()) {
                return 0;
            }
            EventSettings settings = this.this$0.notificationSettingsProvider.getUserSettings(this.event, user.getId());
            if (settings == null) {
                settings = globalSettings;
            }
            boolean send = !isCurrentUserAction && !this.excludeUsers.contains(user);
            send |= settings.isNotifyMyself();
            if (send |= !user.equals(this.this$0.currentUserAware.getCurrentUser())) {
                return settings.getDeliveryType();
            }
            return 0;
        }

        private <T> T ensureLoaded(T object) {
            return (T)this.this$0.loaders.stream().filter(loader -> loader.accept(object)).findFirst().map(loader -> loader.ensureLoaded(object)).orElse(object);
        }
    }
}

