/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.notifications.api.EventSettings;
import org.cxbox.notifications.api.NotificationSettingsProvider;
import org.cxbox.notifications.api.Recipient;
import org.cxbox.notifications.dictionary.NotificationDictionaries;
import org.cxbox.notifications.model.entity.NotificationSettings;
import org.cxbox.notifications.model.entity.NotificationSettings_;
import org.springframework.data.jpa.domain.Specification;

public class BaseNotificationSettingsProvider
implements NotificationSettingsProvider {
    private final JpaDao jpaDao;

    @Override
    public EventSettings getGlobalSettings(LOV event) {
        Specification & Serializable specification = (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(NotificationSettings_.eventName), (Object)event), (Expression)cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.GLOBAL));
        NotificationSettings settings = (NotificationSettings)((Object)this.jpaDao.getFirstResultOrNull(NotificationSettings.class, (Specification)specification));
        if (settings == null) {
            return null;
        }
        return new EventSettings(event, settings.getDeliveryType(), settings.isNotifyMyself(), this.getRecipientTypes(settings));
    }

    @Override
    public EventSettings getUserSettings(LOV event, Long userId) {
        Specification & Serializable specification = (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NotificationSettings_.eventName), (Object)event), cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.PERSONAL), cb.equal((Expression)root.get(NotificationSettings_.userId), (Object)userId)});
        NotificationSettings settings = (NotificationSettings)((Object)this.jpaDao.getFirstResultOrNull(NotificationSettings.class, (Specification)specification));
        if (settings == null) {
            return null;
        }
        return new EventSettings(event, settings.getDeliveryType(), settings.isNotifyMyself(), this.getRecipientTypes(settings));
    }

    protected List<Recipient> getRecipientTypes(NotificationSettings settings) {
        return settings.getNotificationRecipients().stream().map(r -> new Recipient(r.getRecipientType(), r.isSameDeptOnly())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"jpaDao"})
    @Generated
    public BaseNotificationSettingsProvider(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

