/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.Attribute;
import lombok.Generated;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.notifications.api.INotificationTemplate;
import org.cxbox.notifications.api.NotificationEvent;
import org.cxbox.notifications.api.NotificationTemplateSupport;
import org.cxbox.notifications.api.TemplateProcessingService;
import org.cxbox.notifications.model.entity.NotificationTemplate;
import org.cxbox.notifications.model.entity.NotificationTemplate_;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class NotificationTemplateSupportImpl
implements NotificationTemplateSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationTemplateSupportImpl.class);
    private final Attribute<NotificationTemplate, String> SUBJECT = NotificationTemplate_.subject;
    private final Attribute<NotificationTemplate, String> MESSAGE = NotificationTemplate_.message;
    private final Attribute<NotificationTemplate, String> UI_SUBJECT = NotificationTemplate_.uiSubject;
    private final Attribute<NotificationTemplate, String> UI_MESSAGE = NotificationTemplate_.uiMessage;
    private final Attribute<NotificationTemplate, String> URL = NotificationTemplate_.url;
    private final TemplateProcessingService templateService;
    private final JpaDao jpaDao;

    @Override
    public INotificationTemplate getTemplate(LOV event) {
        return (INotificationTemplate)this.jpaDao.getFirstResultOrNull(NotificationTemplate.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(NotificationTemplate_.eventName), (Object)event));
    }

    @Override
    public boolean isTemplateRequired(Map<String, Object> model) {
        for (Attribute<NotificationTemplate, String> attribute : this.getTemplateAttributes()) {
            if (model.get(attribute.getName()) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public NotificationEvent processTemplate(INotificationTemplate notificationTemplate, Map<String, Object> model, NotificationEvent event) {
        try {
            HashMap result = new HashMap();
            List<Attribute<NotificationTemplate, String>> attributes = this.getTemplateAttributes();
            attributes.removeIf(attribute -> {
                Object value = model.get(attribute.getName());
                if (value != null) {
                    result.put(attribute.getName(), value.toString());
                    return true;
                }
                return false;
            });
            attributes.forEach(attribute -> result.putAll(this.templateService.processTemplate(notificationTemplate, model, (Attribute<?, String>)attribute)));
            event.setUrl((String)result.get(this.URL.getName()));
            event.setSubject((String)result.get(this.SUBJECT.getName()));
            event.setMessage((String)result.get(this.MESSAGE.getName()));
            event.setUiSubject((String)result.get(this.UI_SUBJECT.getName()));
            event.setUiMessage((String)result.get(this.UI_MESSAGE.getName()));
            return event;
        }
        catch (Error e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return null;
        }
    }

    private List<Attribute<NotificationTemplate, String>> getTemplateAttributes() {
        return new ArrayList<Attribute<NotificationTemplate, String>>(Arrays.asList(this.SUBJECT, this.MESSAGE, this.UI_SUBJECT, this.UI_MESSAGE, this.URL));
    }

    @ConstructorProperties(value={"templateService", "jpaDao"})
    @Generated
    public NotificationTemplateSupportImpl(TemplateProcessingService templateService, JpaDao jpaDao) {
        this.templateService = templateService;
        this.jpaDao = jpaDao;
    }
}

