/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change;

import com.google.common.collect.ImmutableMap;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.metamodel.Attribute;
import lombok.Generated;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.notifications.api.INotificationTemplate;
import org.cxbox.notifications.model.hbn.change.TemplateProcessingServiceExt;
import org.cxbox.notifications.model.hbn.change.methods.TemplateMethod;
import org.hibernate.Hibernate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class TemplateProcessingServiceImpl
implements TemplateProcessingServiceExt {
    private final Configuration configuration;
    private final StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private final BeansWrapper beansWrapper;
    private final ResourceBundleMessageSource bundles;
    @Autowired
    private List<TemplateMethod> templateMethods;
    @Autowired
    private Environment environment;

    public TemplateProcessingServiceImpl() throws Exception {
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/templates"), this.stringTemplateLoader}));
        this.configuration.setDefaultEncoding("utf-8");
        HashMap<String, Environment> vars = new HashMap<String, Environment>();
        vars.put("environment", this.environment);
        this.configuration.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(vars, this.configuration.getObjectWrapper()));
        this.beansWrapper = new BeansWrapperBuilder(this.configuration.getIncompatibleImprovements()).build();
        this.bundles = new ResourceBundleMessageSource();
        this.bundles.setBasename("templates.messages");
        this.bundles.setParentMessageSource((MessageSource)LocalizationFormatter.getInstance().getBundles());
    }

    private static String processTemplateIntoString(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }

    @Override
    @SafeVarargs
    public final <E extends INotificationTemplate> Map<String, String> processTemplate(E entity, Map<String, Object> model, Attribute<?, String> ... attributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Attribute<?, String> attribute : attributes) {
            result.put(attribute.getName(), this.processTemplate(entity, attribute, model));
        }
        return result;
    }

    private <E extends INotificationTemplate> String processTemplate(E entity, Attribute<?, String> attribute, Map<String, Object> model) {
        return this.processTemplate(this.getTemplate(entity, attribute), model);
    }

    private Template getTemplate(INotificationTemplate entity, Attribute<?, String> attribute) throws Exception {
        long version = entity.getVstamp();
        String attributeName = attribute.getName();
        String key = String.format("%s-%d", attributeName, entity.getId());
        Object source = this.getStringTemplateLoader().findTemplateSource(key);
        long lastModified = -1L;
        if (source != null) {
            lastModified = this.getStringTemplateLoader().getLastModified(source);
        }
        if (version <= lastModified) {
            return this.getConfiguration().getTemplate(key);
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)Hibernate.getClass((Object)entity), (String)attributeName);
        String template = (String)Objects.requireNonNull(propertyDescriptor).getReadMethod().invoke((Object)entity, new Object[0]);
        if (template == null) {
            template = "";
        }
        this.getStringTemplateLoader().putTemplate(key, template, version);
        return this.getConfiguration().getTemplate(key);
    }

    private String processTemplate(Template template, Map<String, Object> model) throws IOException, TemplateException {
        return TemplateProcessingServiceImpl.processTemplateIntoString(template, this.enhanceModel(model));
    }

    @Override
    public String processTemplate(String templateName, Map<String, Object> model) {
        Template template = this.getConfiguration().getTemplate(templateName);
        return this.processTemplate(template, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processTempTemplate(String templateString, Map<String, Object> model) {
        String string;
        if (templateString == null) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        try {
            this.getStringTemplateLoader().putTemplate(id, templateString);
            string = this.processTemplate(id, model);
        }
        catch (Throwable throwable) {
            this.getStringTemplateLoader().removeTemplate(id);
            throw throwable;
        }
        this.getStringTemplateLoader().removeTemplate(id);
        return string;
    }

    private Map<String, Object> enhanceModel(Map<String, Object> model) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(model);
        for (TemplateMethod method : this.templateMethods) {
            builder.put((Object)method.getName(), (Object)method);
        }
        return builder.build();
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public StringTemplateLoader getStringTemplateLoader() {
        return this.stringTemplateLoader;
    }

    @Override
    @Generated
    public BeansWrapper getBeansWrapper() {
        return this.beansWrapper;
    }

    @Override
    @Generated
    public ResourceBundleMessageSource getBundles() {
        return this.bundles;
    }
}

