/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change.managed;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.collections4.keyvalue.AbstractKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.cxbox.api.data.dao.databaselistener.IChangeVector;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.notifications.api.Tracked;
import org.cxbox.notifications.model.api.INotificationEventBuilder;
import org.cxbox.notifications.model.hbn.change.AbstractEventGenerator;

public abstract class AbstractEntityChangedEventGenerator<E extends BaseEntity>
extends AbstractEventGenerator<E> {
    private final List<EntityManager> entityManagers;

    public AbstractEntityChangedEventGenerator(List<EntityManager> entityManagers) {
        this.entityManagers = entityManagers;
    }

    public void process(IChangeVector vector, LOV event) {
        BaseEntity entity = (BaseEntity)vector.unwrap(this.getType());
        if (vector.isUpdate()) {
            HashSet changedFields = new HashSet();
            this.getTrackedFields(this.getEvent()).forEach((attribute, title) -> {
                if (vector.hasChanged(attribute)) {
                    changedFields.add(title);
                }
            });
            if (!changedFields.isEmpty()) {
                this.getBuilder(entity).addModel("changed_fields", changedFields).publish();
            }
        }
    }

    protected INotificationEventBuilder getBuilder(E entity) {
        return this.builder(entity, this.getEvent()).setPerformer(this.getPerformer(entity));
    }

    protected abstract LOV getEvent();

    public boolean canProcess(IChangeVector vector, LOV event) {
        if (!super.canProcess(vector, event)) {
            return false;
        }
        return vector.isUpdate();
    }

    protected INotificationEventBuilder builder(E entity, LOV event) {
        return new AbstractEventGenerator.DefaultBuilder((AbstractEventGenerator)this, entity, event).setPerformer(this.getPerformer(entity));
    }

    protected Map<Attribute<?, ?>, String> getTrackedFields(LOV event) {
        EntityType entityType = this.entityManagers.stream().filter(entityManager -> entityManager.getMetamodel().getEntities().stream().anyMatch(type -> Objects.equals(type.getBindableJavaType(), this.getType()))).findFirst().map(EntityManager::getMetamodel).map(metamodel -> metamodel.entity(this.getType())).orElse(null);
        return Objects.requireNonNull(entityType).getAttributes().stream().map(a -> new DefaultKeyValue(a, (Object)this.getFieldTitle((EntityType<? extends E>)entityType, (Attribute<?, ?>)a, event))).filter(kv -> kv.getValue() != null).collect(Collectors.toMap(AbstractKeyValue::getKey, AbstractKeyValue::getValue));
    }

    private String getFieldTitle(EntityType<? extends E> entityType, Attribute<?, ?> attribute, LOV event) {
        Member member = attribute.getJavaMember();
        if (!(member instanceof Field)) {
            return null;
        }
        Tracked tracked = ((Field)member).getAnnotation(Tracked.class);
        if (tracked == null) {
            return null;
        }
        String[] events = tracked.events();
        if (events.length == 0 || Arrays.asList(events).contains(event.getKey())) {
            return String.format("%s.%s", entityType.getName(), attribute.getName());
        }
        return null;
    }
}

