/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change.managed;

import javax.persistence.metamodel.Attribute;
import org.cxbox.api.data.dao.databaselistener.IChangeVector;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.notifications.model.api.INotificationEventBuilder;
import org.cxbox.notifications.model.hbn.change.AbstractEventGenerator;

public abstract class AbstractFieldChangedEventGenerator<E extends BaseEntity, V>
extends AbstractEventGenerator<E> {
    public void process(IChangeVector vector, LOV event) {
        BaseEntity entity = (BaseEntity)vector.unwrap(this.getType());
        Object value = vector.getValue(this.getField());
        if (vector.isNew() && value != null) {
            this.getBuilder(entity, null).publish();
        }
        if (vector.isUpdate() && vector.hasChanged(this.getField())) {
            Object oldValue = vector.getOldValue(this.getField());
            this.getBuilder(entity, oldValue).publish();
        }
    }

    protected INotificationEventBuilder getBuilder(E entity, V oldValue) {
        return this.builder(entity, this.getEvent()).setPerformer(this.getPerformer(entity));
    }

    protected abstract Attribute<E, V> getField();

    protected abstract LOV getEvent();

    public boolean canProcess(IChangeVector vector, LOV event) {
        if (!super.canProcess(vector, event)) {
            return false;
        }
        if (vector.isNew()) {
            return vector.getValue(this.getField()) != null;
        }
        if (vector.isUpdate()) {
            return vector.hasChanged(this.getField());
        }
        return false;
    }

    protected INotificationEventBuilder builder(E entity, LOV event) {
        return new AbstractEventGenerator.DefaultBuilder((AbstractEventGenerator)this, entity, event);
    }
}

