/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.model.hbn.change.methods;

import freemarker.template.TemplateModelException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.notifications.model.hbn.change.methods.TemplateMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateMethodFullUrl
extends TemplateMethod {
    @Autowired
    private SystemSettings systemSettings;

    @Override
    public String getName() {
        return "fullUrl";
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.isEmpty()) {
            throw new TemplateModelException("empty arguments");
        }
        if (arguments.size() != 1) {
            throw new TemplateModelException("syntax error, expected 1 argument, got: " + arguments);
        }
        String url = this.unwrap(arguments.get(0), String.class);
        String systemUrl = this.systemSettings.getValue(CoreDictionaries.SystemPref.SYSTEM_URL);
        if (StringUtils.isBlank((CharSequence)systemUrl)) {
            return url;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            return systemUrl;
        }
        if (!systemUrl.endsWith("/")) {
            systemUrl = systemUrl + "/";
        }
        if (!systemUrl.endsWith("#/")) {
            systemUrl = systemUrl + "#/";
        }
        return systemUrl + url;
    }
}

