/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.controller;

import java.util.Iterator;
import java.util.List;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.ResultPage;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.util.ResponseBuilder;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.notifications.dao.NotificationDAO;
import org.cxbox.notifications.dto.MarkNotificationDTO;
import org.cxbox.notifications.service.INotificationPollingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}/notification"})
public class NotificationController {
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private List<INotificationPollingService> pollingServices;
    @Autowired
    private SessionService sessionService;

    @GetMapping(value={"/get-notifications"})
    public ResponseDTO getNotifications(@RequestParam(defaultValue="false") boolean unread, @RequestParam(required=false) Long offset, PageSpecification page) {
        return ResponseBuilder.build((ResultPage)ResultPage.of(this.notificationDAO.getNotifications(this.sessionService.getSessionUser().getId(), unread, offset, page), INotificationPollingService::entityToDto));
    }

    @GetMapping(value={"/count-notifications"})
    public ResponseDTO countNotifications(@RequestParam(defaultValue="false") boolean unread, @RequestParam(required=false) Long offset) {
        return ResponseBuilder.build((Object)this.notificationDAO.countNotifications(this.sessionService.getSessionUser().getId(), unread, offset));
    }

    @GetMapping(value={"/check-new-notification"})
    public DeferredResult<ResponseDTO> checkNewNotifications(@RequestParam Long latestNotificationId, @RequestParam(defaultValue="false") boolean unread) {
        INotificationPollingService service;
        DeferredResult<ResponseDTO> result = null;
        Iterator<INotificationPollingService> iterator = this.pollingServices.iterator();
        while (iterator.hasNext() && (result = (service = iterator.next()).addTaskInQueue(this.sessionService.getSessionUser().getId(), latestNotificationId, unread)) == null) {
        }
        return result;
    }

    @PostMapping(value={"/mark-notification-as-read"})
    public MarkNotificationDTO markNotificationsAsRead(@RequestBody MarkNotificationDTO markNotificationDTO) {
        this.notificationDAO.markNotificationsAsRead(markNotificationDTO.getNotificationIds(), markNotificationDTO.getMark(), this.sessionService.getSessionUser().getId());
        return markNotificationDTO;
    }

    @DeleteMapping(value={"/delete-notification"})
    public List<Long> deleteNotifications(@RequestParam List<Long> notificationId) {
        this.notificationDAO.deleteNotifications(notificationId, this.sessionService.getSessionUser().getId());
        return notificationId;
    }

    @PostMapping(value={"/save-notification"})
    public void saveNotification(@RequestParam(value="url") String url, @RequestParam(value="message") String message) {
        this.notificationDAO.saveNotification(url, message, this.sessionService.getSessionUser().getId());
    }
}

