/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.crudma.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.notifications.crudma.api.NotificationRecipientService;
import org.cxbox.notifications.crudma.api.NotificationSettingsService;
import org.cxbox.notifications.crudma.config.NotificationServiceAssociation;
import org.cxbox.notifications.crudma.dto.NotificationRecipientDTO;
import org.cxbox.notifications.crudma.dto.NotificationRecipientDTO_;
import org.cxbox.notifications.crudma.meta.NotificationRecipientFieldMetaBuilder;
import org.cxbox.notifications.model.entity.NotificationRecipient;
import org.cxbox.notifications.model.entity.NotificationRecipient_;
import org.cxbox.notifications.model.entity.NotificationSettings;
import org.cxbox.notifications.model.entity.NotificationSettings_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class NotificationRecipientServiceImpl
extends VersionAwareResponseService<NotificationRecipientDTO, NotificationRecipient>
implements NotificationRecipientService {
    @Autowired
    private NotificationSettingsService notificationSettingsService;
    @Autowired
    private DictionaryCache dictionaryCache;

    public NotificationRecipientServiceImpl() {
        super(NotificationRecipientDTO.class, NotificationRecipient.class, NotificationRecipient_.notificationSettings, NotificationRecipientFieldMetaBuilder.class);
    }

    protected ResultPage<NotificationRecipientDTO> entitiesToDtos(BusinessComponent bc, ResultPage<NotificationRecipient> entities) {
        if (NotificationServiceAssociation.notificationRecipients.isBc((BcIdentifier)bc)) {
            return super.entitiesToDtos(bc, entities);
        }
        Set<LOV> excluded = this.getExclusions(bc);
        return ResultPage.of(entities, entity -> this.entityToDto(bc, (NotificationRecipient)entity, excluded));
    }

    private NotificationRecipientDTO entityToDto(BusinessComponent bc, NotificationRecipient entity, Set<LOV> excluded) {
        NotificationRecipientDTO dto = (NotificationRecipientDTO)super.entityToDto(bc, (BaseEntity)entity);
        dto.setEnabled(!excluded.contains(entity.getRecipientType()));
        return dto;
    }

    private Set<LOV> getExclusions(BusinessComponent bc) {
        NotificationSettings settings = (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, bc.getParentIdAsLong());
        NotificationSettings userSettings = this.notificationSettingsService.getUserSettings(settings.getEventName());
        HashSet<LOV> exclusions = new HashSet<LOV>();
        if (userSettings != null) {
            this.baseDAO.getList(NotificationRecipient.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(NotificationRecipient_.notificationSettings), (Object)userSettings)).stream().map(NotificationRecipient::getRecipientType).filter(Objects::nonNull).forEach(exclusions::add);
        }
        return exclusions;
    }

    protected NotificationRecipientDTO entityToDto(BusinessComponent bc, NotificationRecipient entity) {
        return this.entityToDto(bc, entity, this.getExclusions(bc));
    }

    public Actions<NotificationRecipientDTO> getActions() {
        return Actions.builder().create().available(this::isActionCreateAvailable).add().save().add().delete().available(arg_0 -> ((NotificationServiceAssociation)NotificationServiceAssociation.notificationRecipients).isBc(arg_0)).add().build();
    }

    private boolean isActionCreateAvailable(BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationRecipients.isNotBc((BcIdentifier)bc)) {
            return false;
        }
        NotificationSettings settings = (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, bc.getParentIdAsLong());
        if (settings.getEventName() == null) {
            return false;
        }
        return settings.getNotificationRecipients().size() < this.dictionaryCache.getAll((IDictionaryType)DictionaryType.NOTIFICATION_RECIPIENT_TYPE).size();
    }

    protected CreateResult<NotificationRecipientDTO> doCreateEntity(NotificationRecipient entity, BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationRecipients.isNotBc((BcIdentifier)bc)) {
            throw new UnsupportedOperationException();
        }
        entity.setNotificationSettings((NotificationSettings)this.baseDAO.findById(NotificationSettings.class, bc.getParentIdAsLong()));
        NotificationRecipientDTO result = this.entityToDto(bc, (NotificationRecipient)this.baseDAO.findById(NotificationRecipient.class, (Long)this.baseDAO.save((Object)entity)));
        return new CreateResult((DataResponseDTO)result);
    }

    public ActionResultDTO<NotificationRecipientDTO> deleteEntity(BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationRecipients.isNotBc((BcIdentifier)bc)) {
            throw new UnsupportedOperationException();
        }
        this.notificationSettingsService.evictCache(((NotificationRecipient)this.isExist(bc.getIdAsLong())).getNotificationSettings());
        return super.deleteEntity(bc);
    }

    protected ActionResultDTO<NotificationRecipientDTO> doUpdateEntity(NotificationRecipient recipient, NotificationRecipientDTO data, BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationRecipients.isBc((BcIdentifier)bc)) {
            if (data.isFieldChanged(NotificationRecipientDTO_.recipientType)) {
                LOV recipientType = DictionaryType.NOTIFICATION_RECIPIENT_TYPE.lookupName(data.getRecipientType());
                if (!this.checkDuplicates(bc, recipient, recipientType)) {
                    throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.notification_recipient_already_exists"));
                }
                recipient.setRecipientType(recipientType);
            }
            if (data.isFieldChanged(NotificationRecipientDTO_.sameDeptOnly)) {
                recipient.setSameDeptOnly(data.isSameDeptOnly());
            }
            this.notificationSettingsService.evictCache(recipient.getNotificationSettings());
        } else if (data.getEnabled() != null && data.isFieldChanged(NotificationRecipientDTO_.enabled)) {
            NotificationSettings settings = this.notificationSettingsService.getOrCreateUserCopy(recipient.getNotificationSettings());
            if (data.getEnabled().booleanValue()) {
                this.include(settings, recipient.getRecipientType());
            } else {
                this.exclude(settings, recipient.getRecipientType());
            }
            this.notificationSettingsService.evictCache(settings);
        }
        return new ActionResultDTO((DataResponseDTO)this.entityToDto(bc, recipient));
    }

    private boolean checkDuplicates(BusinessComponent bc, NotificationRecipient entity, LOV recipientType) {
        return !this.baseDAO.exists(NotificationRecipient.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NotificationRecipient_.recipientType), (Object)recipientType), this.getParentSpecification(bc).toPredicate(root, cq, cb), cb.notEqual((Expression)root, (Object)entity)}));
    }

    private void include(NotificationSettings settings, LOV recipientType) {
        this.baseDAO.delete(NotificationRecipient.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(NotificationRecipient_.notificationSettings).get(NotificationSettings_.id), (Object)settings.getId()), (Expression)cb.equal((Expression)root.get(NotificationRecipient_.recipientType), (Object)recipientType)));
    }

    private NotificationRecipient exclude(NotificationSettings settings, LOV recipientType) {
        NotificationRecipient exclude = new NotificationRecipient();
        exclude.setRecipientType(recipientType);
        exclude.setNotificationSettings(settings);
        exclude = (NotificationRecipient)this.baseDAO.findById(NotificationRecipient.class, (Long)this.baseDAO.save((Object)exclude));
        return exclude;
    }
}

