/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.crudma.impl;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.notifications.crudma.api.NotificationSettingsService;
import org.cxbox.notifications.crudma.config.NotificationServiceAssociation;
import org.cxbox.notifications.crudma.dto.NotificationSettingsDTO;
import org.cxbox.notifications.crudma.dto.NotificationTemplateDTO_;
import org.cxbox.notifications.crudma.meta.NotificationSettingsFieldMetaBuilder;
import org.cxbox.notifications.dictionary.NotificationDictionaries;
import org.cxbox.notifications.model.entity.NotificationRecipient;
import org.cxbox.notifications.model.entity.NotificationRecipient_;
import org.cxbox.notifications.model.entity.NotificationSettings;
import org.cxbox.notifications.model.entity.NotificationSettings_;
import org.cxbox.notifications.service.CacheableNotificationSettingsProvider;
import org.cxbox.notifications.service.IDeliveryService;
import org.cxbox.notifications.service.impl.DeliveryServiceRegistry;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class NotificationSettingsServiceImpl
extends VersionAwareResponseService<NotificationSettingsDTO, NotificationSettings>
implements NotificationSettingsService {
    @Autowired
    private DeliveryServiceRegistry serviceRegistry;
    @Autowired
    private DictionaryCache dictionaryCache;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private TransactionService txService;
    @Autowired
    private CacheableNotificationSettingsProvider notificationSettingsCache;

    public NotificationSettingsServiceImpl() {
        super(NotificationSettingsDTO.class, NotificationSettings.class, null, NotificationSettingsFieldMetaBuilder.class);
    }

    protected ResultPage<NotificationSettingsDTO> entitiesToDtos(BusinessComponent bc, ResultPage<NotificationSettings> entities) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bc)) {
            return ResultPage.of(entities, entity -> this.entityToDto(bc, (NotificationSettings)entity, null));
        }
        Map userSettings = this.baseDAO.getList(NotificationSettings.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.PERSONAL), (Expression)cb.equal((Expression)root.get(NotificationSettings_.userId), (Object)this.sessionService.getSessionUser().getId()))).stream().collect(Collectors.toMap(NotificationSettings::getEventName, Function.identity()));
        return ResultPage.of(entities, entity -> this.entityToDto(bc, (NotificationSettings)entity, (NotificationSettings)userSettings.get(entity.getEventName())));
    }

    protected NotificationSettingsDTO entityToDto(BusinessComponent bc, NotificationSettings entity, NotificationSettings userSettings) {
        if (userSettings == null) {
            userSettings = entity;
        }
        NotificationSettingsDTO result = (NotificationSettingsDTO)super.entityToDto(bc, (BaseEntity)entity);
        for (IDeliveryService service : this.serviceRegistry.getServiceList()) {
            String deliveryType = service.getDeliveryType();
            int serviceId = service.getServiceId();
            boolean enabled = (userSettings.getDeliveryType() & serviceId) == serviceId;
            this.setDeliveryType(result, deliveryType, enabled);
        }
        return result;
    }

    protected NotificationSettingsDTO entityToDto(BusinessComponent bc, NotificationSettings entity) {
        NotificationSettings userSettings = null;
        if (NotificationServiceAssociation.notificationGlobalSettings.isNotBc((BcIdentifier)bc)) {
            userSettings = this.getUserSettings(entity.getEventName());
        }
        return this.entityToDto(bc, entity, userSettings);
    }

    protected Specification<NotificationSettings> getParentSpecification(BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.GLOBAL);
        }
        return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.isNotNull((Expression)root.get(NotificationSettings_.eventName)), (Expression)cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.GLOBAL));
    }

    protected CreateResult<NotificationSettingsDTO> doCreateEntity(NotificationSettings entity, BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isNotBc((BcIdentifier)bc)) {
            throw new UnsupportedOperationException();
        }
        entity.setSettingsType(NotificationDictionaries.NotificationSettingsType.GLOBAL);
        entity.setDeliveryType(this.getDefaultDeliveryType());
        return new CreateResult((DataResponseDTO)this.entityToDto(bc, (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, (Long)this.baseDAO.save((Object)entity))));
    }

    protected ActionResultDTO<NotificationSettingsDTO> doUpdateEntity(NotificationSettings entity, NotificationSettingsDTO dto, BusinessComponent bc) {
        NotificationSettings mutable = entity;
        if (NotificationServiceAssociation.notificationGlobalSettings.isNotBc((BcIdentifier)bc)) {
            mutable = this.getOrCreateUserCopy(mutable);
        }
        for (IDeliveryService service : this.serviceRegistry.getServiceList()) {
            Boolean value = this.getDeliveryTypeValue(dto, service.getDeliveryType());
            if (value == null) continue;
            int deliveryType = mutable.getDeliveryType();
            deliveryType = value.booleanValue() ? (deliveryType |= service.getServiceId()) : (deliveryType &= Integer.MAX_VALUE ^ service.getServiceId());
            mutable.setDeliveryType(deliveryType);
        }
        if (dto.isFieldChanged(NotificationTemplateDTO_.eventName)) {
            LOV eventName = DictionaryType.DATABASE_EVENT.lookupName(dto.getEventName());
            if (!this.checkDuplicates(mutable, eventName)) {
                throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.notification_setting_already_exists"));
            }
            mutable.setEventName(eventName);
        }
        this.evictCache(mutable);
        return new ActionResultDTO((DataResponseDTO)this.entityToDto(bc, entity));
    }

    public Actions<NotificationSettingsDTO> getActions() {
        return Actions.builder().create().available(this::isActionCreateAvailable).add().save().add().delete().available(arg_0 -> ((NotificationServiceAssociation)NotificationServiceAssociation.notificationGlobalSettings).isBc(arg_0)).add().action("reset", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c").available(this::isActionResetAvailable).invoker(this::resetSettings).add().action("reset-all", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0432\u0441\u0435").available(arg_0 -> ((NotificationServiceAssociation)NotificationServiceAssociation.notificationGlobalSettings).isNotBc(arg_0)).invoker(this::resetAllSettings).add().build();
    }

    private boolean isActionResetAvailable(BusinessComponent bc) {
        Long id = bc.getIdAsLong();
        if (id == null || NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bc)) {
            return false;
        }
        NotificationSettings entity = (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, id);
        return this.getUserSettings(entity.getEventName()) != null;
    }

    private ActionResultDTO<NotificationSettingsDTO> resetAllSettings(BusinessComponent bc, NotificationSettingsDTO data) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bc)) {
            throw new UnsupportedOperationException();
        }
        this.baseDAO.getStream(NotificationSettings.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.PERSONAL), (Expression)cb.equal((Expression)root.get(NotificationSettings_.userId), (Object)this.sessionService.getSessionUser().getId()))).forEach(this::delete);
        return new ActionResultDTO().setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    private ActionResultDTO<NotificationSettingsDTO> resetSettings(BusinessComponent bc, NotificationSettingsDTO data) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bc)) {
            throw new UnsupportedOperationException();
        }
        Long id = bc.getIdAsLong();
        NotificationSettings entity = (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, id);
        if ((entity = this.getUserSettings(entity.getEventName())) != null) {
            this.delete(entity);
        }
        return new ActionResultDTO().setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    private boolean isActionCreateAvailable(BusinessComponent bc) {
        if (NotificationServiceAssociation.notificationGlobalSettings.isNotBc((BcIdentifier)bc)) {
            return false;
        }
        return this.baseDAO.getCount(NotificationSettings.class, this.getParentSpecification(null)) < (long)this.dictionaryCache.getAll((IDictionaryType)DictionaryType.DATABASE_EVENT).size();
    }

    private boolean checkDuplicates(NotificationSettings entity, LOV eventName) {
        return !this.baseDAO.exists(NotificationSettings.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NotificationSettings_.eventName), (Object)eventName), cb.notEqual((Expression)root, (Object)entity), this.getParentSpecification(null).toPredicate(root, cq, cb)}));
    }

    public ActionResultDTO<NotificationSettingsDTO> deleteEntity(BusinessComponent bc) {
        NotificationSettings settings = (NotificationSettings)this.isExist(bc.getIdAsLong());
        this.delete(settings);
        return new ActionResultDTO();
    }

    private void delete(NotificationSettings entity) {
        this.deleteRecipients(entity);
        this.baseDAO.delete((AbstractEntity)entity);
        this.evictCache(entity);
    }

    private void deleteRecipients(NotificationSettings settings) {
        this.baseDAO.delete(NotificationRecipient.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(NotificationRecipient_.notificationSettings).get(NotificationSettings_.id), (Object)settings.getId()));
    }

    private int getDefaultDeliveryType() {
        int result = 0;
        for (IDeliveryService service : this.serviceRegistry.getServiceList()) {
            int serviceId = service.getServiceId();
            if (!service.isActive()) continue;
            result |= serviceId;
        }
        return result;
    }

    private Boolean getDeliveryTypeValue(NotificationSettingsDTO dto, String deliveryType) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(((Object)((Object)dto)).getClass(), (String)deliveryType);
        if (descriptor == null) {
            return null;
        }
        Method method = Objects.requireNonNull(BeanUtils.getPropertyDescriptor(((Object)((Object)dto)).getClass(), (String)deliveryType)).getReadMethod();
        return (Boolean)method.invoke((Object)dto, new Object[0]);
    }

    private void setDeliveryType(NotificationSettingsDTO dto, String deliveryType, boolean enabled) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(((Object)((Object)dto)).getClass(), (String)deliveryType);
        if (descriptor != null) {
            Method method = Objects.requireNonNull(BeanUtils.getPropertyDescriptor(((Object)((Object)dto)).getClass(), (String)deliveryType)).getWriteMethod();
            method.invoke((Object)dto, enabled);
        }
    }

    @Override
    public void evictCache(NotificationSettings settings) {
        if (NotificationDictionaries.NotificationSettingsType.GLOBAL.equals((Object)settings.getSettingsType())) {
            this.txService.invokeAfterCompletion(Invoker.of(() -> this.notificationSettingsCache.evict(settings.getEventName())));
        } else if (NotificationDictionaries.NotificationSettingsType.PERSONAL.equals((Object)settings.getSettingsType())) {
            this.txService.invokeAfterCompletion(Invoker.of(() -> this.notificationSettingsCache.evict(settings.getEventName(), settings.getUserId())));
        }
    }

    @Override
    public NotificationSettings getOrCreateUserCopy(NotificationSettings entity) {
        NotificationSettings copy = this.getUserSettings(entity.getEventName());
        if (copy != null) {
            return copy;
        }
        copy = new NotificationSettings();
        copy.setSettingsType(NotificationDictionaries.NotificationSettingsType.PERSONAL);
        copy.setUserId(this.sessionService.getSessionUser().getId());
        copy.setDeliveryType(entity.getDeliveryType());
        copy.setEventName(entity.getEventName());
        return (NotificationSettings)this.baseDAO.findById(NotificationSettings.class, (Long)this.baseDAO.save((Object)copy));
    }

    @Override
    public NotificationSettings getGlobalSettings(LOV event) {
        return (NotificationSettings)this.baseDAO.getFirstResultOrNull(NotificationSettings.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(NotificationSettings_.eventName), (Object)event), (Expression)cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.GLOBAL)));
    }

    @Override
    public NotificationSettings getUserSettings(LOV event) {
        return (NotificationSettings)this.baseDAO.getFirstResultOrNull(NotificationSettings.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NotificationSettings_.settingsType), (Object)NotificationDictionaries.NotificationSettingsType.PERSONAL), cb.equal((Expression)root.get(NotificationSettings_.userId), (Object)this.sessionService.getSessionUser().getId()), cb.equal((Expression)root.get(NotificationSettings_.eventName), (Object)event)}));
    }
}

