/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.crudma.meta;

import java.util.ArrayList;
import java.util.List;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.rowmeta.FieldsMeta;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.notifications.crudma.config.NotificationServiceAssociation;
import org.cxbox.notifications.crudma.dto.NotificationSettingsDTO;
import org.cxbox.notifications.crudma.dto.NotificationSettingsDTO_;
import org.cxbox.notifications.model.entity.NotificationSettings;
import org.cxbox.notifications.service.IDeliveryService;
import org.cxbox.notifications.service.impl.DeliveryServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationSettingsFieldMetaBuilder
extends FieldMetaBuilder<NotificationSettingsDTO> {
    @Autowired
    private DeliveryServiceRegistry registry;
    @Autowired
    private JpaDao jpaDao;

    public void buildRowDependentMeta(RowDependentFieldsMeta<NotificationSettingsDTO> fields, InnerBcDescription bcDescription, Long id, Long parentId) {
        fields.setDictionaryTypeWithAllValues(NotificationSettingsDTO_.eventName, (IDictionaryType)DictionaryType.DATABASE_EVENT);
        fields.setRequired(new DtoField[]{NotificationSettingsDTO_.eventName});
        this.getEnabledFields().forEach(xva$0 -> fields.setEnabled(new DtoField[]{xva$0}));
        this.getDisabledFields().forEach(xva$0 -> fields.setDisabled(new DtoField[]{xva$0}));
        if (NotificationServiceAssociation.notificationGlobalSettings.isBc((BcIdentifier)bcDescription)) {
            if (id == null) {
                fields.setEnabled(new DtoField[]{NotificationSettingsDTO_.eventName});
            } else {
                NotificationSettings settings = (NotificationSettings)this.jpaDao.findById(NotificationSettings.class, id);
                if (settings.getNotificationRecipients().isEmpty()) {
                    fields.setEnabled(new DtoField[]{NotificationSettingsDTO_.eventName});
                }
            }
        }
    }

    public void buildIndependentMeta(FieldsMeta<NotificationSettingsDTO> fields, InnerBcDescription bcDescription, Long parentId) {
        fields.enableFilter(new DtoField[]{NotificationSettingsDTO_.eventName});
        fields.setAllFilterValuesByLovType(NotificationSettingsDTO_.eventName, (IDictionaryType)DictionaryType.DATABASE_EVENT);
        this.getDisabledFields().forEach(xva$0 -> fields.setHidden(new DtoField[]{xva$0}));
    }

    private List<DtoField> getEnabledFields() {
        ArrayList<DtoField> result = new ArrayList<DtoField>();
        for (IDeliveryService service : this.registry.getServiceList()) {
            if (!service.isActive()) continue;
            result.add(new DtoField(service.getDeliveryType()));
        }
        return result;
    }

    private List<DtoField> getDisabledFields() {
        ArrayList<DtoField> result = new ArrayList<DtoField>();
        for (IDeliveryService service : this.registry.getServiceList()) {
            if (service.isActive()) continue;
            result.add(new DtoField(service.getDeliveryType()));
        }
        return result;
    }
}

