/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.dao.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.util.Collections;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.notifications.dao.NotificationDAO;
import org.cxbox.notifications.dao.impl.NotificationSpecifications;
import org.cxbox.notifications.model.entity.Notification;
import org.cxbox.notifications.model.entity.Notification_;
import org.cxbox.notifications.service.NotificationDeferredResult;
import org.cxbox.notifications.service.impl.PushDeliveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class NotificationDAOImpl
implements NotificationDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationDAOImpl.class);
    @Autowired
    private JpaDao jpaDao;
    @Autowired
    private PushDeliveryService pushDeliveryService;

    @Override
    public ResultPage<Notification> getNotifications(Long recipientId, boolean unread, Long offset, PageSpecification page) {
        return this.jpaDao.getPage(Notification.class, this.getNotificationSpecification(recipientId, unread, offset, true), (PageSpecification)(page.isProvided() ? page : null));
    }

    @Override
    public long countNotifications(Long recipientId, boolean unread, Long offset) {
        return this.jpaDao.getCount(Notification.class, this.getNotificationSpecification(recipientId, unread, offset, false));
    }

    private Specification<Notification> getNotificationSpecification(Long recipientId, boolean unread, Long offset, boolean order) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(cb.equal((Expression)root.get(Notification_.recipientId), (Object)recipientId));
            predicates.add(cb.equal((Expression)root.get(Notification_.pushBit), (Object)1));
            if (unread) {
                predicates.add(cb.equal((Expression)root.get(Notification_.readBit), (Object)0));
            }
            if (offset != null) {
                predicates.add(cb.lessThan((Expression)root.get(Notification_.id), (Comparable)offset));
            }
            if (order) {
                cq.orderBy(new Order[]{cb.desc((Expression)root.get(Notification_.createdDate))});
            }
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Override
    public Map<Long, List<Notification>> checkNewNotifications(List<NotificationDeferredResult> recipients) {
        ArrayList notifications = new ArrayList();
        for (List chunk : Lists.partition(recipients, (int)500)) {
            notifications.addAll(this.jpaDao.getList(Notification.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(Notification_.pushBit), (Object)1), (Expression)cb.or((Predicate[])chunk.stream().map(e -> {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(cb.equal((Expression)root.get(Notification_.recipientId), (Object)e.getRecipientId()));
                if (e.getLatestNotificationId() > 0L) {
                    predicates.add(cb.greaterThan((Expression)root.get(Notification_.id), (Comparable)e.getLatestNotificationId()));
                }
                return cb.and(predicates.toArray(new Predicate[0]));
            }).toArray(Predicate[]::new)))));
        }
        return notifications.stream().collect(Collectors.groupingBy(Notification::getRecipientId, Collections.toSortedList(Comparator.comparing(BaseEntity::getId).reversed())));
    }

    @Override
    public void markNotificationsAsRead(List<Long> notificationId, Boolean mark, Long recipientId) {
        for (List chunk : Lists.partition(notificationId, (int)500)) {
            this.jpaDao.update(Notification.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)root.get(Notification_.id).in((Collection)chunk), (Expression)cb.equal((Expression)root.get(Notification_.recipientId), (Object)recipientId)), NotificationSpecifications.markDelivered(this.pushDeliveryService.getServiceId(), mark));
        }
    }

    @Override
    public void markDelivered(Notification notification, int serviceId) {
        this.jpaDao.update(Notification.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(Notification_.id), (Object)notification.getId()), NotificationSpecifications.markDelivered(serviceId, true));
    }

    @Override
    public void deleteNotifications(List<Long> notificationId, Long recipientId) {
        for (List chunk : Lists.partition(notificationId, (int)500)) {
            this.jpaDao.delete(Notification.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)root.get(Notification_.id).in((Collection)chunk), (Expression)cb.equal((Expression)root.get(Notification_.recipientId), (Object)recipientId)));
        }
    }

    @Override
    public Long saveNotification(String url, String message, Long recipientId) {
        Notification notification = Notification.builder().uiMessage(message).deliveryType(this.pushDeliveryService.getServiceId()).url(url).recipientId(recipientId).build();
        return (Long)this.jpaDao.save((Object)notification);
    }
}

