/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.dto;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import lombok.Generated;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.TZAware;
import org.cxbox.core.dto.Lov;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.impl.BooleanValueProvider;
import org.cxbox.notifications.model.entity.Notification;

public class NotificationDTO
extends DataResponseDTO {
    @SearchParameter(name="uiSubject")
    private String subject;
    @SearchParameter(name="uiMessage")
    private String message;
    @SearchParameter(provider=BooleanValueProvider.class)
    private boolean read;
    private String url;
    @Lov(value=DictionaryType.MIME_TYPE)
    private String mimeType;
    private Long recipientId;
    @TZAware
    private LocalDateTime createdDate;

    public NotificationDTO(Notification entity) {
        this.id = entity.getId().toString();
        this.subject = entity.getUiSubject();
        this.message = entity.getUiMessage();
        this.recipientId = entity.getRecipientId();
        this.url = entity.getUrl();
        this.createdDate = entity.getCreatedDate();
        this.read = entity.isRead();
        if (entity.getMimeType() != null) {
            this.mimeType = entity.getMimeType().getKey();
        }
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean isRead() {
        return this.read;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public Long getRecipientId() {
        return this.recipientId;
    }

    @Generated
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setRead(boolean read) {
        this.read = read;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public void setRecipientId(Long recipientId) {
        this.recipientId = recipientId;
    }

    @Generated
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public NotificationDTO() {
    }

    @ConstructorProperties(value={"subject", "message", "read", "url", "mimeType", "recipientId", "createdDate"})
    @Generated
    public NotificationDTO(String subject, String message, boolean read, String url, String mimeType, Long recipientId, LocalDateTime createdDate) {
        this.subject = subject;
        this.message = message;
        this.read = read;
        this.url = url;
        this.mimeType = mimeType;
        this.recipientId = recipientId;
        this.createdDate = createdDate;
    }
}

