/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.service.impl;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.system.ISystemSettingChangeEventListener;
import org.cxbox.api.system.SystemSettingChangedEvent;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.api.util.tz.TimeZoneUtil;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.util.ResponseBuilder;
import org.cxbox.notifications.dao.NotificationDAO;
import org.cxbox.notifications.dictionary.NotificationDictionaries;
import org.cxbox.notifications.model.entity.Notification;
import org.cxbox.notifications.service.INotificationPollingService;
import org.cxbox.notifications.service.NotificationDeferredResult;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.context.request.async.DeferredResult;

public class AbstractNotificationPollingService
implements ISystemSettingChangeEventListener,
INotificationPollingService {
    private final SystemSettings systemSettings;
    private final NotificationDAO notificationDAO;
    private final LinkedBlockingDeque<NotificationDeferredResult> responseBodyQueue = new LinkedBlockingDeque();
    private boolean enabled;

    @PostConstruct
    protected void init() {
        this.enabled = this.systemSettings.getBooleanValue(NotificationDictionaries.SystemPref.FEATURE_NOTIFICATIONS);
    }

    public void onApplicationEvent(SystemSettingChangedEvent event) {
        if (NotificationDictionaries.SystemPref.FEATURE_NOTIFICATIONS.equals((Object)event.getSetting())) {
            this.enabled = this.systemSettings.getBooleanValue(NotificationDictionaries.SystemPref.FEATURE_NOTIFICATIONS);
        }
    }

    @Override
    public DeferredResult<ResponseDTO> addTaskInQueue(Long recipientId, Long latestNotificationId, boolean unread) {
        NotificationDeferredResult result = new NotificationDeferredResult(recipientId, latestNotificationId, TimeZoneUtil.getSessionZoneId(), unread);
        if (this.enabled) {
            this.responseBodyQueue.add(result);
        }
        return result;
    }

    private void addToHead(NotificationDeferredResult result) {
        if (!result.isSetOrExpired()) {
            this.responseBodyQueue.addFirst(result);
        }
    }

    private Deque<NotificationDeferredResult> snapshot() {
        LinkedList<NotificationDeferredResult> result = new LinkedList<NotificationDeferredResult>();
        this.responseBodyQueue.drainTo(result);
        return result;
    }

    @Scheduled(fixedRate=1000L)
    public void executePollTaskInQueue() {
        if (!this.enabled) {
            return;
        }
        this.doExecutePollTaskInQueue();
    }

    private void doExecutePollTaskInQueue() {
        NotificationDeferredResult result;
        Deque<NotificationDeferredResult> snapshot = this.snapshot();
        snapshot.removeIf(DeferredResult::isSetOrExpired);
        if (snapshot.isEmpty()) {
            return;
        }
        ArrayList<NotificationDeferredResult> recipients = new ArrayList<NotificationDeferredResult>(snapshot.stream().collect(Collectors.toMap(NotificationDeferredResult::getRecipientId, Function.identity(), BinaryOperator.minBy(Comparator.comparingLong(NotificationDeferredResult::getLatestNotificationId)))).values());
        if (recipients.isEmpty()) {
            return;
        }
        Map<Long, List<Notification>> notifications = this.notificationDAO.checkNewNotifications(recipients);
        while ((result = snapshot.pollLast()) != null) {
            Long lastId = result.getLatestNotificationId();
            ZoneId zoneId = result.getZoneId();
            boolean unread = result.isUnread();
            boolean bl = notifications.getOrDefault(result.getRecipientId(), Collections.emptyList()).stream().filter(n -> n.getId() > lastId && (!unread || !n.isRead())).map(entity -> INotificationPollingService.entityToDto(entity, zoneId)).collect(Collectors.collectingAndThen(Collectors.collectingAndThen(Collectors.toList(), list -> ResponseBuilder.build((ResultPage)ResultPage.of((List)list, (boolean)false))), arg_0 -> ((NotificationDeferredResult)result).setResult(arg_0)));
        }
    }

    @ConstructorProperties(value={"systemSettings", "notificationDAO"})
    @Generated
    public AbstractNotificationPollingService(SystemSettings systemSettings, NotificationDAO notificationDAO) {
        this.systemSettings = systemSettings;
        this.notificationDAO = notificationDAO;
    }
}

