/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.notifications.service.impl;

import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.cxbox.api.exception.ServerException;
import org.cxbox.notifications.service.IDeliveryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliveryServiceRegistry {
    @Autowired
    private List<IDeliveryService> serviceList;

    @PostConstruct
    protected void init() {
        HashSet<Integer> seen = new HashSet<Integer>();
        for (IDeliveryService service : this.serviceList) {
            boolean valid;
            int serviceId = service.getServiceId();
            boolean bl = valid = (serviceId & serviceId - 1) == 0;
            if (valid && seen.add(serviceId)) continue;
            throw new ServerException(String.format("service %s is invalid", service.getClass()));
        }
    }

    @Generated
    public List<IDeliveryService> getServiceList() {
        return this.serviceList;
    }
}

