/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.quartz.config;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import lombok.Generated;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.quartz.config.SchedulerProperties;
import org.cxbox.quartz.impl.QuartzJobFactory;
import org.cxbox.quartz.impl.QuartzSchedulerListener;
import org.quartz.SchedulerListener;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={SchedulerProperties.class})
public class SchedulerConfig {
    private final Environment environment;
    private final ApplicationContext applicationContext;
    private final QuartzJobFactory quartzJobFactory;
    private final QuartzSchedulerListener quartzSchedulerListener;
    private final PlatformTransactionManager transactionManager;
    private final TaskExecutor taskExecutor;
    private final SchedulerProperties schedulerProperties;

    @Bean
    public SchedulerFactoryBean quartzScheduler(ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties, @Qualifier(value="primaryDatabase") Database primaryDatabase) {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setAutoStartup(!this.environment.acceptsProfiles(new String[]{"quartzDisable"}));
        schedulerFactoryBean.setStartupDelay((int)this.schedulerProperties.getStartupDelay().getSeconds());
        schedulerFactoryBean.setOverwriteExistingJobs(true);
        schedulerFactoryBean.setApplicationContext(applicationContext);
        schedulerFactoryBean.setTaskExecutor((Executor)this.taskExecutor);
        schedulerFactoryBean.setJobFactory((JobFactory)this.quartzJobFactory);
        schedulerFactoryBean.setTransactionManager(this.transactionManager);
        schedulerFactoryBean.setSchedulerName(this.schedulerProperties.getSchedulerName());
        DataSource dataSource = (DataSource)applicationContext.getBean(cxboxBeanProperties.getDataSource(), DataSource.class);
        schedulerFactoryBean.setDataSource((DataSource)new TransactionAwareDataSourceProxy(dataSource));
        Properties quartzProperties = new Properties();
        quartzProperties.setProperty("org.quartz.scheduler.skipUpdateCheck", String.valueOf(true));
        quartzProperties.setProperty("org.quartz.jobStore.class", LocalDataSourceJobStore.class.getName());
        quartzProperties.setProperty("org.quartz.jobStore.tablePrefix", "QRTZ_");
        if (Objects.equal((Object)primaryDatabase, (Object)Database.POSTGRESQL)) {
            quartzProperties.setProperty("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        }
        schedulerFactoryBean.setQuartzProperties(quartzProperties);
        schedulerFactoryBean.setSchedulerListeners(new SchedulerListener[]{this.quartzSchedulerListener});
        return schedulerFactoryBean;
    }

    @Bean
    public TransactionProxyFactoryBean quartzSchedulerService(SchedulerFactoryBean quartzScheduler) {
        TransactionProxyFactoryBean transactionProxyFactoryBean = new TransactionProxyFactoryBean();
        transactionProxyFactoryBean.setTransactionManager(this.transactionManager);
        transactionProxyFactoryBean.setTarget((Object)quartzScheduler.getObject());
        Properties properties = new Properties();
        properties.setProperty("*", "PROPAGATION_REQUIRED");
        transactionProxyFactoryBean.setTransactionAttributes(properties);
        return transactionProxyFactoryBean;
    }

    @ConstructorProperties(value={"environment", "applicationContext", "quartzJobFactory", "quartzSchedulerListener", "transactionManager", "taskExecutor", "schedulerProperties"})
    @Generated
    public SchedulerConfig(Environment environment, ApplicationContext applicationContext, QuartzJobFactory quartzJobFactory, QuartzSchedulerListener quartzSchedulerListener, PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, SchedulerProperties schedulerProperties) {
        this.environment = environment;
        this.applicationContext = applicationContext;
        this.quartzJobFactory = quartzJobFactory;
        this.quartzSchedulerListener = quartzSchedulerListener;
        this.transactionManager = transactionManager;
        this.taskExecutor = taskExecutor;
        this.schedulerProperties = schedulerProperties;
    }
}

