/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.quartz.crudma.dto;

import java.time.LocalDateTime;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.dto.Lov;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.impl.BooleanValueProvider;
import org.cxbox.core.util.filter.provider.impl.DateValueProvider;
import org.cxbox.core.util.filter.provider.impl.LovValueProvider;
import org.cxbox.quartz.model.ScheduledJob;

public class ScheduledJobDTO
extends DataResponseDTO {
    @Lov(value=DictionaryType.SCHEDULED_SERVICES)
    @SearchParameter(provider=LovValueProvider.class, name="service")
    private String serviceName;
    private String serviceKey;
    private String cronExpression;
    @SearchParameter(provider=DateValueProvider.class)
    private LocalDateTime lastLaunchDate;
    @Lov(value=DictionaryType.LAUNCH_STATUS)
    @SearchParameter(provider=LovValueProvider.class, name="lastLaunchStatus")
    private String launchStatusCd;
    @SearchParameter(provider=BooleanValueProvider.class)
    private boolean active;

    public ScheduledJobDTO(ScheduledJob job) {
        this.id = job.getId().toString();
        this.serviceKey = Optional.ofNullable(job.getService()).map(LOV::getKey).orElse(null);
        this.serviceName = DictionaryType.SCHEDULED_SERVICES.lookupValue(job.getService());
        this.cronExpression = job.getCronExpression();
        this.launchStatusCd = DictionaryType.LAUNCH_STATUS.lookupValue(job.getLastLaunchStatus());
        this.lastLaunchDate = job.getLastLaunchDate();
        this.active = job.isActive();
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getServiceKey() {
        return this.serviceKey;
    }

    @Generated
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Generated
    public LocalDateTime getLastLaunchDate() {
        return this.lastLaunchDate;
    }

    @Generated
    public String getLaunchStatusCd() {
        return this.launchStatusCd;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    @Generated
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Generated
    public void setLastLaunchDate(LocalDateTime lastLaunchDate) {
        this.lastLaunchDate = lastLaunchDate;
    }

    @Generated
    public void setLaunchStatusCd(String launchStatusCd) {
        this.launchStatusCd = launchStatusCd;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public ScheduledJobDTO() {
    }
}

