/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.quartz.crudma.service;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.quartz.crudma.dto.ScheduledJobDTO;
import org.cxbox.quartz.crudma.dto.ScheduledJobDTO_;
import org.cxbox.quartz.crudma.meta.ScheduledJobFieldMetaBuilder;
import org.cxbox.quartz.crudma.service.ScheduledJobService;
import org.cxbox.quartz.impl.SchedulerService;
import org.cxbox.quartz.model.ScheduledJob;
import org.cxbox.quartz.model.ScheduledJob_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ScheduledJobServiceImpl
extends VersionAwareResponseService<ScheduledJobDTO, ScheduledJob>
implements ScheduledJobService {
    @Autowired
    private SchedulerService schedulerService;

    public ScheduledJobServiceImpl() {
        super(ScheduledJobDTO.class, ScheduledJob.class, null, ScheduledJobFieldMetaBuilder.class);
    }

    protected Specification<ScheduledJob> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)super.getParentSpecification(bc).toPredicate(root, cq, cb), (Expression)cb.equal((Expression)root.get(ScheduledJob_.system), (Object)false));
    }

    public Actions<ScheduledJobDTO> getActions() {
        return Actions.builder().create().add().save().add().delete().add().action("launchNow", LocalizationFormatter.uiMessage((String)"action.launch")).available(this::isServiceDefined).invoker(this::launchNow).add().build();
    }

    protected CreateResult<ScheduledJobDTO> doCreateEntity(ScheduledJob entity, BusinessComponent bc) {
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((ScheduledJobDTO)this.entityToDto(bc, entity)));
    }

    private boolean isServiceDefined(BusinessComponent bc) {
        if (bc.getId() == null) {
            return false;
        }
        return ((ScheduledJob)this.baseDAO.findById(ScheduledJob.class, bc.getIdAsLong())).getService() != null;
    }

    private ActionResultDTO<ScheduledJobDTO> launchNow(BusinessComponent bc, ScheduledJobDTO data) {
        ScheduledJob job = (ScheduledJob)this.baseDAO.findById(ScheduledJob.class, bc.getIdAsLong());
        this.schedulerService.launchNow(job);
        return new ActionResultDTO((DataResponseDTO)((ScheduledJobDTO)this.entityToDto(bc, job)));
    }

    protected ActionResultDTO<ScheduledJobDTO> doUpdateEntity(ScheduledJob job, ScheduledJobDTO data, BusinessComponent bc) {
        if (data.hasChangedFields()) {
            if (data.isFieldChanged(ScheduledJobDTO_.serviceName)) {
                this.onServiceChanged(job, this.validateServiceName(data.getServiceName()));
            }
            if (data.isFieldChanged(ScheduledJobDTO_.cronExpression)) {
                job.setCronExpression(this.validateCronExpression(data.getCronExpression()));
            }
            if (data.isFieldChanged(ScheduledJobDTO_.active)) {
                job.setActive(data.isActive());
            }
        }
        this.schedulerService.scheduleJob(job);
        return new ActionResultDTO((DataResponseDTO)((ScheduledJobDTO)this.entityToDto(bc, job))).setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    protected void onServiceChanged(ScheduledJob job, LOV serviceName) {
        job.setService(serviceName);
        job.getParams().forEach(param -> this.baseDAO.delete((AbstractEntity)param));
    }

    private LOV validateServiceName(String title) {
        LOV service = DictionaryType.SCHEDULED_SERVICES.lookupName(title);
        if (service != null) {
            return service;
        }
        throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.empty_service_name"));
    }

    private String validateCronExpression(String cronExpression) {
        try {
            return this.schedulerService.validateCronExpression(cronExpression);
        }
        catch (IllegalArgumentException ex) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.wrong_cron_expression"));
        }
    }

    public ActionResultDTO<ScheduledJobDTO> deleteEntity(BusinessComponent bc) {
        ScheduledJob job = (ScheduledJob)this.baseDAO.findById(ScheduledJob.class, bc.getIdAsLong());
        this.schedulerService.removeJob(job);
        job.getParams().forEach(param -> this.baseDAO.delete((AbstractEntity)param));
        return super.deleteEntity(bc);
    }
}

