/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.quartz.impl;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.util.DateTimeUtil;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.quartz.impl.ScheduledService;
import org.cxbox.quartz.model.ScheduledJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="quartzJobFactory")
public class QuartzJobFactory
extends AdaptableJobFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobFactory.class);
    private final JpaDao jpaDao;
    private final InternalAuthorizationService authzService;
    private final TransactionService txService;
    private final ApplicationContext applicationContext;
    private Authentication authentication;

    @PostConstruct
    public void init() {
        this.authentication = this.authzService.createAuthentication(InternalAuthorizationService.VANILLA);
    }

    public Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        String jobName = bundle.getJobDetail().getKey().getName();
        ScheduledJob scheduledJob = null;
        if (NumberUtils.isParsable((String)jobName)) {
            long id = NumberUtils.toLong((String)jobName);
            scheduledJob = (ScheduledJob)this.jpaDao.findById(ScheduledJob.class, Long.valueOf(id));
        }
        if (scheduledJob == null) {
            return super.createJobInstance(bundle);
        }
        Object job = this.applicationContext.getBean(scheduledJob.getService().getKey());
        if (job instanceof ScheduledService) {
            return new DelegatingJob((ScheduledService)job, scheduledJob);
        }
        return job;
    }

    @ConstructorProperties(value={"jpaDao", "authzService", "txService", "applicationContext"})
    @Generated
    public QuartzJobFactory(JpaDao jpaDao, InternalAuthorizationService authzService, TransactionService txService, ApplicationContext applicationContext) {
        this.jpaDao = jpaDao;
        this.authzService = authzService;
        this.txService = txService;
        this.applicationContext = applicationContext;
    }

    class DelegatingJob
    implements Job {
        private final ScheduledService delegate;
        private final ScheduledJob job;
        private Throwable deferredException;

        DelegatingJob(ScheduledService delegate, ScheduledJob job) {
            this.delegate = Objects.requireNonNull(delegate, "ScheduledService must not be null");
            this.job = Objects.requireNonNull(job, "ScheduledJob must not be null");
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            QuartzJobFactory.this.authzService.loginAs(QuartzJobFactory.this.authentication);
            this.doExecute();
            if (this.deferredException != null) {
                throw new JobExecutionException(this.deferredException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doExecute() {
            boolean success = false;
            long start = System.currentTimeMillis();
            long duration = 0L;
            LocalDateTime lastLaunchDate = DateTimeUtil.now();
            try {
                QuartzJobFactory.this.txService.invokeNoTx(() -> {
                    this.delegate.execute(this.job);
                    return null;
                });
                success = true;
                duration = System.currentTimeMillis() - start;
            }
            catch (Error e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                this.deferredException = t;
                log.error(t.getMessage(), t);
            }
            finally {
                this.updateJobInfo(success, duration, lastLaunchDate);
            }
        }

        private void updateJobInfo(boolean success, long duration, LocalDateTime lastLaunchDate) {
            QuartzJobFactory.this.txService.invokeInTx(() -> {
                ScheduledJob job = (ScheduledJob)QuartzJobFactory.this.jpaDao.findById(ScheduledJob.class, this.job.getId());
                job.setLastLaunchDate(lastLaunchDate);
                job.setLaunchCnt(job.getLaunchCnt() + 1L);
                if (success) {
                    job.setLaunchFailedLastCnt(0L);
                    job.setLastSuccessLaunchDate(lastLaunchDate);
                    job.setLastSuccessLaunchDuration(duration);
                    job.setLastLaunchStatus(CoreDictionaries.LaunchStatus.SUCCESS);
                } else {
                    job.setLaunchFailedCnt(job.getLaunchFailedCnt() + 1L);
                    job.setLaunchFailedLastCnt(job.getLaunchFailedLastCnt() + 1L);
                    job.setLastLaunchStatus(CoreDictionaries.LaunchStatus.FAILED);
                }
                return null;
            });
        }
    }
}

