/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.quartz.impl;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.cxbox.api.exception.ServerException;
import org.cxbox.quartz.impl.QuartzStatefulNoOpJob;
import org.cxbox.quartz.impl.SchedulerService;
import org.cxbox.quartz.model.ScheduledJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SchedulerServiceImpl
implements SchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    public static final ITriggerFilter CRON_TRIGGER_FILTER = trigger -> trigger instanceof CronTrigger;
    @Autowired
    @Qualifier(value="quartzSchedulerService")
    private Scheduler scheduler;

    @Override
    public void onBoot(ScheduledJob job) {
        try {
            JobDetail detail = this.scheduler.getJobDetail(new JobKey(job.getId().toString()));
            if (detail == null && job.isActive()) {
                this.scheduleJob(job);
                if (job.isLaunchOnCreate()) {
                    this.launchNow(job);
                }
            }
        }
        catch (Exception ex) {
            throw new ServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void scheduleJob(ScheduledJob job) {
        try {
            JobBuilder jobBuilder = JobBuilder.newJob().ofType(QuartzStatefulNoOpJob.class);
            jobBuilder.withIdentity(job.getId().toString());
            jobBuilder.storeDurably();
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            JobDetail jobDetail = jobBuilder.build();
            Trigger trigger = triggerBuilder.withSchedule((ScheduleBuilder)scheduleBuilder).build();
            HashMap<JobDetail, Set<Trigger>> jobData = new HashMap<JobDetail, Set<Trigger>>();
            jobData.put(jobDetail, Collections.singleton(trigger));
            this.removeTriggers(job, CRON_TRIGGER_FILTER);
            this.scheduler.scheduleJobs(jobData, true);
            log.info("Job {} (ID:{}) has been scheduled successfully", (Object)job.getService().getKey(), (Object)job.getId());
            if (!job.isActive()) {
                this.pauseJob(job, CRON_TRIGGER_FILTER);
            } else {
                this.resumeJob(job, CRON_TRIGGER_FILTER);
            }
        }
        catch (Exception ex) {
            throw new ServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void removeJob(ScheduledJob job) {
        try {
            this.scheduler.deleteJob(new JobKey(job.getId().toString()));
            log.info("Job {} (ID: {}) has been deleted", (Object)job.getService().getKey(), (Object)job.getId());
        }
        catch (Exception ex) {
            throw new ServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void launchNow(ScheduledJob job) {
        try {
            JobDetail detail = this.scheduler.getJobDetail(new JobKey(job.getId().toString()));
            if (detail == null) {
                this.scheduleJob(job);
            }
            this.scheduler.triggerJob(new JobKey(job.getId().toString()));
            log.info("Job {} (ID: {}) has been launched immediately", (Object)job.getService().getKey(), (Object)job.getId());
        }
        catch (Exception ex) {
            throw new ServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public String validateCronExpression(String cronExpression) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser cronParser = new CronParser(cronDefinition);
        cronParser.parse(cronExpression);
        return cronExpression;
    }

    private void resumeJob(ScheduledJob job, ITriggerFilter filter) throws Exception {
        List triggers = this.scheduler.getTriggersOfJob(new JobKey(job.getId().toString()));
        for (Trigger trigger : triggers) {
            if (!filter.matches(trigger)) continue;
            this.scheduler.resumeTrigger(trigger.getKey());
            log.debug("Job {} (ID: {}): trigger {} has been resumed", new Object[]{job.getService().getKey(), job.getId(), trigger.toString()});
        }
        log.info("Job {} (ID: {}) has been resumed", (Object)job.getService().getKey(), (Object)job.getId());
    }

    private void pauseJob(ScheduledJob job, ITriggerFilter filter) throws Exception {
        List triggers = this.scheduler.getTriggersOfJob(new JobKey(job.getId().toString()));
        for (Trigger trigger : triggers) {
            if (!filter.matches(trigger)) continue;
            this.scheduler.pauseTrigger(trigger.getKey());
            log.debug("Job {} (ID: {}): trigger {} has been paused", new Object[]{job.getService().getKey(), job.getId(), trigger.toString()});
        }
        log.info("Job {} (ID: {}) has been paused", (Object)job.getService().getKey(), (Object)job.getId());
    }

    private void removeTriggers(ScheduledJob job, ITriggerFilter filter) throws Exception {
        List triggers = this.scheduler.getTriggersOfJob(new JobKey(job.getId().toString()));
        for (Trigger trigger : triggers) {
            if (!filter.matches(trigger)) continue;
            this.scheduler.unscheduleJob(trigger.getKey());
            log.debug("Job {} (ID: {}): trigger {} has been unscheduled", new Object[]{job.getService().getKey(), job.getId(), trigger.toString()});
        }
        log.info("Job {} (ID: {}) has been unscheduled", (Object)job.getService().getKey(), (Object)job.getId());
    }

    private static interface ITriggerFilter {
        public boolean matches(Trigger var1);
    }
}

