/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.crudma;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.api.exception.ServerException;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.model.ui.entity.Bc;
import org.cxbox.sqlbc.crudma.SqlBcDescription;
import org.cxbox.sqlbc.dao.SqlBcQuery;
import org.cxbox.sqlbc.dao.SqlFieldType;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Component
public class SqlBcCreator {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ObjectMapper objectMapper;

    public SqlBcCreator(ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)applicationContext.getBean(cxboxBeanProperties.getDataSource(), DataSource.class));
        this.objectMapper = objectMapper;
    }

    public SqlBcDescription getDescription(Bc bc) {
        List<SqlBcDescription.Bind> binds = this.getBindsFromJson(bc.getBinds());
        return new SqlBcDescription(bc, binds, new SqlBcFieldsLazyInitializer(bc.getQuery(), binds));
    }

    private List<SqlBcDescription.Bind> getBindsFromJson(String bindsString) {
        try {
            List binds = (List)this.objectMapper.readValue(bindsString, (TypeReference)new TypeReference<List<SqlBcDescription.Bindings>>(){});
            ArrayList<SqlBcDescription.Bind> sqlBcDescriptionBinds = new ArrayList<SqlBcDescription.Bind>();
            binds.forEach(bind -> {
                String key;
                String string = key = "pickList".equals(bind.getType()) ? (String)bind.getPickMap().entrySet().stream().filter(entry -> "id".equals(entry.getValue())).findFirst().get().getKey() : bind.getKey();
                if (bind.getOperations() == null) {
                    sqlBcDescriptionBinds.add(new SqlBcDescription.Bind(key, null));
                } else {
                    for (Map<String, Object> operationData : bind.getOperations()) {
                        String operationType = operationData.entrySet().stream().filter(entry -> "type".equals(entry.getKey())).findFirst().get().getValue().toString();
                        sqlBcDescriptionBinds.add(new SqlBcDescription.Bind(key + "_" + operationType, SearchOperation.of((String)operationType)));
                    }
                }
            });
            return sqlBcDescriptionBinds;
        }
        catch (IOException e) {
            throw new ServerException(e.getMessage(), (Throwable)e);
        }
    }

    private final class SqlBcFieldsLazyInitializer
    extends LazyInitializer<List<SqlBcDescription.Field>> {
        private final Timestamp zeroDate = new Timestamp(0L);
        private final String query;
        private final List<SqlBcDescription.Bind> binds;

        protected List<SqlBcDescription.Field> initialize() {
            MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource().addValue("userid", (Object)0L).addValue("userrole", (Object)"").addValue("userdeptid", (Object)0L).addValue("isfilterabledata", (Object)"N").addValue("parentid", (Object)"").addValue("datefrom", (Object)this.zeroDate).addValue("dateto", (Object)this.zeroDate).addValue("datefrom_tzaware", (Object)this.zeroDate).addValue("dateto_tzaware", (Object)this.zeroDate).addValue("timezone", (Object)ZoneId.systemDefault().getId()).addValue("datefrom2", (Object)this.zeroDate).addValue("dateto2", (Object)this.zeroDate).addValue("id", (Object)0L);
            for (SqlBcDescription.Bind bind : this.binds) {
                if (!bind.isExistInQuery(this.query)) continue;
                mapSqlParameterSource.addValue(bind.getBindName(), null);
            }
            SqlRowSet rowSet = SqlBcCreator.this.jdbcTemplate.queryForRowSet(String.format("select * from (%s) sqlquery where 0=1", this.query), (SqlParameterSource)mapSqlParameterSource);
            SqlRowSetMetaData metaData = rowSet.getMetaData();
            ArrayList<SqlBcDescription.Field> fields = new ArrayList<SqlBcDescription.Field>();
            for (int columnNumber = 1; columnNumber <= metaData.getColumnCount(); ++columnNumber) {
                String columnName = metaData.getColumnName(columnNumber);
                SqlFieldType type = SqlFieldType.Holder.getFromSqlType(metaData.getColumnType(columnNumber));
                fields.add(new SqlBcDescription.Field(columnName, type, Boolean.FALSE));
            }
            this.addExtraFields(fields);
            return fields;
        }

        private void addExtraFields(List<SqlBcDescription.Field> fields) {
            SqlBcQuery.EXTRA_FIELDS.forEach((k, v) -> fields.add(new SqlBcDescription.Field((String)k, (SqlFieldType)((Object)v), true)));
        }

        @ConstructorProperties(value={"query", "binds"})
        @Generated
        public SqlBcFieldsLazyInitializer(String query, List<SqlBcDescription.Bind> binds) {
            this.query = query;
            this.binds = binds;
        }
    }
}

