/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.crudma;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.cxbox.api.util.tz.TimeZoneUtil;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.model.ui.entity.Bc;
import org.cxbox.sqlbc.crudma.SqlCrudmaService;
import org.cxbox.sqlbc.dao.SqlFieldType;
import org.cxbox.sqlbc.exception.BadSqlComponentException;

public final class SqlBcDescription
extends BcDescription {
    private final String query;
    private final String defaultOrder;
    private final String reportDateField;
    private final boolean editable;
    private final LazyInitializer<List<Field>> fieldsInitializer;
    private final List<Bind> binds;

    public SqlBcDescription(Bc bc, List<Bind> binds, LazyInitializer<List<Field>> fieldsInitializer) {
        super(bc.getName(), bc.getParentName(), SqlCrudmaService.class, Boolean.TRUE.equals(bc.getRefresh()));
        this.id = bc.getId();
        this.query = bc.getQuery();
        this.defaultOrder = bc.getDefaultOrder();
        this.reportDateField = bc.getReportDateField();
        this.pageLimit = bc.getPageLimit();
        this.editable = Boolean.TRUE.equals(bc.getEditable());
        this.fieldsInitializer = fieldsInitializer;
        this.binds = binds;
        this.bindsString = bc.getBinds();
    }

    public List<Field> getFields() {
        try {
            return (List)this.fieldsInitializer.get();
        }
        catch (Exception e) {
            throw new BadSqlComponentException(this.getName(), e);
        }
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getDefaultOrder() {
        return this.defaultOrder;
    }

    @Generated
    public String getReportDateField() {
        return this.reportDateField;
    }

    @Generated
    public boolean isEditable() {
        return this.editable;
    }

    @Generated
    public List<Bind> getBinds() {
        return this.binds;
    }

    public static final class Bindings {
        private String title;
        private String key;
        private String type;
        private List<Map<String, Object>> operations;
        private String popupBcName;
        private Map<String, Object> pickMap;
        private List<String> dictionaryValues;
        private Boolean permanent;

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<Map<String, Object>> getOperations() {
            return this.operations;
        }

        @Generated
        public String getPopupBcName() {
            return this.popupBcName;
        }

        @Generated
        public Map<String, Object> getPickMap() {
            return this.pickMap;
        }

        @Generated
        public List<String> getDictionaryValues() {
            return this.dictionaryValues;
        }

        @Generated
        public Boolean getPermanent() {
            return this.permanent;
        }

        @ConstructorProperties(value={"title", "key", "type", "operations", "popupBcName", "pickMap", "dictionaryValues", "permanent"})
        @Generated
        public Bindings(String title, String key, String type, List<Map<String, Object>> operations, String popupBcName, Map<String, Object> pickMap, List<String> dictionaryValues, Boolean permanent) {
            this.title = title;
            this.key = key;
            this.type = type;
            this.operations = operations;
            this.popupBcName = popupBcName;
            this.pickMap = pickMap;
            this.dictionaryValues = dictionaryValues;
            this.permanent = permanent;
        }

        @Generated
        public Bindings() {
        }
    }

    public static final class Bind {
        private String bindName;
        private SearchOperation type;

        public boolean isExistInQuery(String query) {
            return query.contains(":" + this.getBindName());
        }

        @Generated
        public String getBindName() {
            return this.bindName;
        }

        @Generated
        public SearchOperation getType() {
            return this.type;
        }

        @ConstructorProperties(value={"bindName", "type"})
        @Generated
        public Bind(String bindName, SearchOperation type) {
            this.bindName = bindName;
            this.type = type;
        }
    }

    public static final class Field {
        private final String columnName;
        private final SqlFieldType type;
        private final Boolean editable;

        public String getFieldName() {
            return this.columnName.toLowerCase();
        }

        public boolean isTzAware() {
            return TimeZoneUtil.hasTzAwareSuffix((String)this.getFieldName()) && this.getType().isChronological();
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public SqlFieldType getType() {
            return this.type;
        }

        @Generated
        public Boolean getEditable() {
            return this.editable;
        }

        @ConstructorProperties(value={"columnName", "type", "editable"})
        @Generated
        public Field(String columnName, SqlFieldType type, Boolean editable) {
            this.columnName = columnName;
            this.type = type;
            this.editable = editable;
        }
    }
}

