/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.dao;

import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import lombok.Generated;

public enum SqlFieldType {
    STRING(String.class, false),
    CLOB(String.class, false),
    BIG_DECIMAL(BigDecimal.class, false),
    BOOLEAN(Boolean.class, false),
    BYTE(Byte.class, false),
    SHORT(Short.class, false),
    INTEGER(Integer.class, false),
    LONG(Long.class, false),
    FLOAT(Float.class, false),
    DOUBLE(Double.class, false),
    DATE(Timestamp.class, true),
    TIME(Timestamp.class, true),
    TIMESTAMP(Timestamp.class, true);

    private final Class<?> javaClass;
    private final boolean chronological;

    @Generated
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Generated
    public boolean isChronological() {
        return this.chronological;
    }

    @ConstructorProperties(value={"javaClass", "chronological"})
    @Generated
    private SqlFieldType(Class<?> javaClass, boolean chronological) {
        this.javaClass = javaClass;
        this.chronological = chronological;
    }

    public static final class Holder {
        private static final Map<Integer, SqlFieldType> TYPES = ImmutableMap.builder().put((Object)1, (Object)STRING).put((Object)12, (Object)STRING).put((Object)2005, (Object)CLOB).put((Object)-1, (Object)STRING).put((Object)2, (Object)BIG_DECIMAL).put((Object)3, (Object)BIG_DECIMAL).put((Object)-7, (Object)BOOLEAN).put((Object)-6, (Object)BYTE).put((Object)5, (Object)SHORT).put((Object)4, (Object)INTEGER).put((Object)-5, (Object)LONG).put((Object)7, (Object)FLOAT).put((Object)6, (Object)FLOAT).put((Object)8, (Object)DOUBLE).put((Object)91, (Object)DATE).put((Object)92, (Object)TIME).put((Object)93, (Object)TIMESTAMP).build();

        public static SqlFieldType getFromSqlType(int sqlType) {
            if (!TYPES.containsKey(sqlType)) {
                throw new IllegalArgumentException(String.format("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 sql-\u0442\u0438\u043f: %d", sqlType));
            }
            return TYPES.get(sqlType);
        }

        @Generated
        private Holder() {
        }
    }
}

