/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.sql.query;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.sqlbc.export.base.model.ColumnMeta;
import org.cxbox.sqlbc.export.sql.db.ColumnValue;
import org.cxbox.sqlbc.export.sql.query.Query;

public class Insert
implements Query {
    private final String tableName;
    private final BigDecimal lineId;
    private final Map<String, ColumnValue> columns = new LinkedHashMap<String, ColumnValue>();

    public void addColumn(ColumnMeta meta, Object value) {
        if (value != null) {
            this.columns.put(meta.getName().toUpperCase(), new ColumnValue(meta.getType(), value));
        }
    }

    public Object getValue(String columnName) {
        ColumnValue columnValue = this.columns.get(columnName.toUpperCase());
        return columnValue == null ? null : columnValue.getObjectValue();
    }

    @Override
    public String toSql() {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, ColumnValue> column : this.columns.entrySet()) {
            columnNames.add(column.getKey());
            values.add(column.getValue().getValueForInsert());
        }
        return String.format("INSERT INTO %s (%s) VALUES (%s);", this.tableName, StringUtils.join(columnNames, (String)", "), StringUtils.join(values, (String)", "));
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public BigDecimal getLineId() {
        return this.lineId;
    }

    @Generated
    public Map<String, ColumnValue> getColumns() {
        return this.columns;
    }

    @Generated
    public String toString() {
        return "Insert(tableName=" + this.getTableName() + ", lineId=" + this.getLineId() + ", columns=" + this.getColumns() + ")";
    }

    @ConstructorProperties(value={"tableName", "lineId"})
    @Generated
    public Insert(String tableName, BigDecimal lineId) {
        this.tableName = tableName;
        this.lineId = lineId;
    }
}

