/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.api.util.CxCollections;
import org.cxbox.sqlbc.export.base.JdbcTemplateSqlExporter;
import org.cxbox.sqlbc.export.base.Parameters;
import org.cxbox.sqlbc.export.base.model.ColumnMeta;
import org.cxbox.sqlbc.export.sql.query.Insert;
import org.cxbox.sqlbc.export.sql.query.UpdateForeignKey;
import org.cxbox.sqlbc.export.sql.transform.ValueTransformer;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class SqlExportQueryBuilder {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final JdbcTemplateSqlExporter jdbcTemplateSqlExporter;

    SqlExportQueryBuilder(JdbcTemplateSqlExporter jdbcTemplateSqlExporter, ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)applicationContext.getBean(cxboxBeanProperties.getDataSource(), DataSource.class));
        this.jdbcTemplateSqlExporter = jdbcTemplateSqlExporter;
    }

    public List<Insert> inserts(ValueTransformer valueTransformer, String tableName, Parameters parameters, String ... ignoredColumns) {
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        if (parameters.isNotEmpty()) {
            this.jdbcTemplateSqlExporter.queryForMap(tableName, parameters, ignoredColumns).forEach(exportedRecord -> {
                Insert insert = new Insert(tableName, exportedRecord.getId());
                exportedRecord.getColumns().forEach((key, value) -> insert.addColumn((ColumnMeta)key, valueTransformer.get(tableName, key.getName(), value)));
                inserts.add(insert);
            });
        }
        return inserts;
    }

    public List<UpdateForeignKey> updateForeignKeys(ValueTransformer valueTransformer, String tableName, Parameters parameters, String ... columns) {
        ArrayList<UpdateForeignKey> inserts = new ArrayList<UpdateForeignKey>();
        if (parameters.isNotEmpty()) {
            for (List ids : CxCollections.partition(parameters.getIds(), (int)500)) {
                this.jdbcTemplate.query(String.format("select * from %s where %s in(:ids) and (1 = 2%s) order by id", tableName, parameters.getColumnName(), this.notNullCondition(columns)), (SqlParameterSource)new MapSqlParameterSource("ids", (Object)ids), rs -> {
                    UpdateForeignKey update = new UpdateForeignKey(tableName, (BigDecimal)valueTransformer.get(tableName, "ID", rs.getBigDecimal("ID")));
                    for (String column : columns) {
                        update.addColumn(column, (BigDecimal)valueTransformer.get(tableName, column, rs.getBigDecimal(column)));
                    }
                    inserts.add(update);
                });
            }
        }
        return inserts;
    }

    private String notNullCondition(String ... columns) {
        StringBuilder where = new StringBuilder();
        for (String column : columns) {
            where.append(" or ").append(column).append(" is not null");
        }
        return where.toString();
    }
}

