/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.sql.db;

import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.cxbox.api.util.CxCollections;
import org.cxbox.sqlbc.dao.SqlFieldType;

public class ColumnValue {
    private final SqlFieldType type;
    private final Object objectValue;

    public String getValueForInsert() {
        switch (this.type) {
            case STRING: {
                return "'" + this.escapeString(this.objectValue) + "'";
            }
            case CLOB: {
                return CxCollections.split((String)String.valueOf(this.objectValue), (int)2000).stream().map(this::escapeString).map(string -> "TO_CLOB('" + string + "')").collect(Collectors.joining(" || "));
            }
            case BOOLEAN: {
                return BooleanUtils.isTrue((Boolean)((Boolean)this.objectValue)) ? "1" : "0";
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return this.timestamp(this.objectValue);
            }
        }
        return String.valueOf(this.objectValue);
    }

    private String escapeString(Object src) {
        return String.valueOf(src).replace("'", "''");
    }

    private String timestamp(Object src) {
        return "TO_TIMESTAMP('" + String.valueOf(src) + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Generated
    public SqlFieldType getType() {
        return this.type;
    }

    @Generated
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Generated
    public String toString() {
        return "ColumnValue(type=" + String.valueOf((Object)this.getType()) + ", objectValue=" + String.valueOf(this.getObjectValue()) + ")";
    }

    @ConstructorProperties(value={"type", "objectValue"})
    @Generated
    public ColumnValue(SqlFieldType type, Object objectValue) {
        this.type = type;
        this.objectValue = objectValue;
    }
}

