/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.sql.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.sqlbc.export.sql.query.BlankLine;
import org.cxbox.sqlbc.export.sql.query.Comment;
import org.cxbox.sqlbc.export.sql.query.Insert;
import org.cxbox.sqlbc.export.sql.query.Query;

public class MultipleQuery
implements Query {
    private final boolean onlyQuery;
    private final List<Query> queries = new ArrayList<Query>();

    public MultipleQuery() {
        this(false);
    }

    public void query(Query sql) {
        this.queries.add(sql);
        this.blankLine();
    }

    public void queries(List<? extends Query> sql) {
        if (!sql.isEmpty()) {
            this.queries.addAll(sql);
            this.blankLine();
        }
    }

    public void comment(String text) {
        if (!this.onlyQuery) {
            this.queries.add(new Comment(text));
        }
    }

    public void blankLine() {
        if (!this.onlyQuery) {
            this.queries.add(new BlankLine());
        }
    }

    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    @Override
    public String toSql() {
        return this.queries.stream().map(Query::toSql).collect(Collectors.joining("\n"));
    }

    public List<Insert> getInserts(String tableName) {
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        for (Query query : this.queries) {
            Insert queryInsert;
            if (!(query instanceof Insert) || !Objects.equals((queryInsert = (Insert)query).getTableName(), tableName)) continue;
            inserts.add(queryInsert);
        }
        return inserts;
    }

    @Generated
    public String toString() {
        return "MultipleQuery(onlyQuery=" + this.onlyQuery + ", queries=" + String.valueOf(this.getQueries()) + ")";
    }

    @ConstructorProperties(value={"onlyQuery"})
    @Generated
    public MultipleQuery(boolean onlyQuery) {
        this.onlyQuery = onlyQuery;
    }
}

