/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.crudma;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.service.AsyncService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.crudma.bc.RefreshableBcSupplier;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.sqlbc.crudma.SqlBcCreator;
import org.cxbox.sqlbc.crudma.SqlBcDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"deploymentTransactionSupport"})
@Service
public final class SqlBcSupplier
implements RefreshableBcSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlBcSupplier.class);
    private final AsyncService asyncService;
    private final TransactionService txService;
    private final JpaDao jpaDao;
    private final MetaRepository metaRepository;
    private final SqlBcCreator sqlBcCreator;
    private Map<String, SqlBcDescription> sqlBcMap;

    public SqlBcSupplier(AsyncService asyncService, TransactionService txService, JpaDao jpaDao, MetaRepository metaRepository, SqlBcCreator sqlBcCreator) {
        this.asyncService = asyncService;
        this.txService = txService;
        this.jpaDao = jpaDao;
        this.metaRepository = metaRepository;
        this.sqlBcCreator = sqlBcCreator;
        this.sqlBcMap = this.loadAllBcNames();
        this.loadData(true);
    }

    public BcDescription getBcDescription(String bcName) {
        return this.sqlBcMap.get(bcName);
    }

    private void loadData(boolean startup) {
        this.asyncService.invokeAsync(() -> (Void)this.txService.invokeInTx(Invoker.of(() -> this.doLoadData(startup))));
    }

    private void doLoadData(boolean startup) {
        this.sqlBcMap.forEach((name, desc) -> {
            try {
                desc.getFields();
            }
            catch (Exception ex) {
                if (startup) {
                    log.error(ex.getLocalizedMessage());
                }
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        });
    }

    public List<String> getAllBcNames() {
        return new ArrayList<String>(this.sqlBcMap.keySet());
    }

    public void refresh() {
        this.sqlBcMap = this.loadAllBcNames();
        this.loadData(false);
    }

    private Map<String, SqlBcDescription> loadAllBcNames() {
        return this.metaRepository.getBcs().stream().map(this.sqlBcCreator::getDescription).collect(Collectors.toMap(BcDescription::getName, Function.identity()));
    }
}

