/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.dao;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import lombok.Generated;

public enum SqlFieldType {
    STRING(String.class, false),
    CLOB(String.class, false),
    BIG_DECIMAL(BigDecimal.class, false),
    BOOLEAN(Boolean.class, false),
    BYTE(Byte.class, false),
    SHORT(Short.class, false),
    INTEGER(Integer.class, false),
    LONG(Long.class, false),
    FLOAT(Float.class, false),
    DOUBLE(Double.class, false),
    DATE(Timestamp.class, true),
    TIME(Timestamp.class, true),
    TIMESTAMP(Timestamp.class, true);

    private final Class<?> javaClass;
    private final boolean chronological;

    @Generated
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Generated
    public boolean isChronological() {
        return this.chronological;
    }

    @ConstructorProperties(value={"javaClass", "chronological"})
    @Generated
    private SqlFieldType(Class<?> javaClass, boolean chronological) {
        this.javaClass = javaClass;
        this.chronological = chronological;
    }

    public static final class Holder {
        private static final Map<Integer, SqlFieldType> TYPES = Map.ofEntries(Map.entry(1, STRING), Map.entry(12, STRING), Map.entry(2005, CLOB), Map.entry(-1, STRING), Map.entry(2, BIG_DECIMAL), Map.entry(3, BIG_DECIMAL), Map.entry(-7, BOOLEAN), Map.entry(-6, BYTE), Map.entry(5, SHORT), Map.entry(4, INTEGER), Map.entry(-5, LONG), Map.entry(7, FLOAT), Map.entry(6, FLOAT), Map.entry(8, DOUBLE), Map.entry(91, DATE), Map.entry(92, TIME), Map.entry(93, TIMESTAMP));

        public static SqlFieldType getFromSqlType(int sqlType) {
            if (!TYPES.containsKey(sqlType)) {
                throw new IllegalArgumentException(String.format("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 sql-\u0442\u0438\u043f: %d", sqlType));
            }
            return TYPES.get(sqlType);
        }

        @Generated
        private Holder() {
        }
    }
}

