/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.dao.binds;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.sqlbc.dao.binds.SqlNamedParameterQueryBinder;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class SqlNamedParameterQueryBinderImpl
implements SqlNamedParameterQueryBinder {
    private final Map<Class, String> escapeTypes = Map.of(Timestamp.class, "{ts '%s'}", String.class, "'%s'");
    private final DataSource dataSource;

    public SqlNamedParameterQueryBinderImpl(ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties) {
        this.dataSource = (DataSource)applicationContext.getBean(cxboxBeanProperties.getDataSource(), DataSource.class);
    }

    @Override
    public String bindVariables(String sql, SqlParameterSource paramSource) throws SQLException {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        for (SqlParameter sp : declaredParameters) {
            Object paramValue = paramSource.getValue(sp.getName());
            if (paramValue == null) continue;
            String replacement = paramValue.toString();
            if (this.escapeTypes.containsKey(paramValue.getClass())) {
                replacement = String.format(this.escapeTypes.get(paramValue.getClass()), paramValue.toString());
            }
            sql = sql.replaceFirst(":" + sp.getName(), replacement);
        }
        return this.validate(sql);
    }

    private String validate(String sql) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            String string;
            block12: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.getParameterMetaData();
                    string = sql;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return string;
        }
    }
}

