/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.base;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.sqlbc.dao.SqlFieldType;
import org.cxbox.sqlbc.export.base.ExportedRecordRowMapper;
import org.cxbox.sqlbc.export.base.Parameters;
import org.cxbox.sqlbc.export.base.model.ExportedRecord;
import org.cxbox.sqlbc.export.base.model.TableMeta;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Component
public class JdbcTemplateSqlExporter {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public JdbcTemplateSqlExporter(ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)applicationContext.getBean(cxboxBeanProperties.getDataSource(), DataSource.class));
    }

    public List<ExportedRecord> queryForMap(String tableName, Parameters parameters, String ... ignoredColumns) {
        ArrayList<ExportedRecord> result = new ArrayList<ExportedRecord>();
        if (parameters.isNotEmpty()) {
            TableMeta tableMeta = this.getTableMeta(tableName, this.getAllIgnoredColumns(ignoredColumns));
            for (List ids : Lists.partition(parameters.getIds(), (int)500)) {
                result.addAll(this.jdbcTemplate.query(String.format("select * from %s where %s in(:ids) order by id", tableMeta.getTableName(), parameters.getColumnName()), (SqlParameterSource)new MapSqlParameterSource("ids", (Object)ids), (RowMapper)new ExportedRecordRowMapper(tableMeta)));
            }
        }
        return result;
    }

    private Set<String> getAllIgnoredColumns(String ... ignoredColumns) {
        HashSet<String> result = new HashSet<String>(Arrays.asList("CREATED_DATE", "UPDATED_DATE", "CREATED_BY_USER_ID", "LAST_UPD_BY_USER_ID", "VSTAMP"));
        Stream.of(ignoredColumns).map(String::toUpperCase).forEach(result::add);
        return result;
    }

    private TableMeta getTableMeta(String tableName, Set<String> ignoredColumns) {
        SqlRowSetMetaData metaData = this.jdbcTemplate.queryForRowSet(String.format("select * from (select * from %s) as exported_table where 1=0", tableName), (SqlParameterSource)new EmptySqlParameterSource()).getMetaData();
        TableMeta tableMeta = new TableMeta(tableName);
        for (int columnNumber = 1; columnNumber <= metaData.getColumnCount(); ++columnNumber) {
            String columnName = metaData.getColumnName(columnNumber).toUpperCase();
            if (ignoredColumns.contains(columnName)) continue;
            tableMeta.addColumn(columnName, SqlFieldType.Holder.getFromSqlType(metaData.getColumnType(columnNumber)));
        }
        return tableMeta;
    }
}

