/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.base;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.cxbox.sqlbc.export.base.model.ExportedRecord;
import org.cxbox.sqlbc.export.sql.query.Insert;

public class Parameters {
    private final String columnName;
    private final Set<BigDecimal> ids = new TreeSet<BigDecimal>();

    public static Parameters id(String columnName, Long id) {
        return new Parameters(columnName).add(BigDecimal.valueOf(id));
    }

    public static Parameters id(Long id) {
        return Parameters.id("ID", id);
    }

    public static Parameters ids(List<?> objects) {
        return Parameters.ids("ID", objects);
    }

    public static Parameters ids(String columnName, List<?> objects) {
        Parameters parameters = new Parameters(columnName);
        for (Object object : objects) {
            if (object instanceof Insert) {
                parameters.add(((Insert)object).getLineId());
                continue;
            }
            if (!(object instanceof ExportedRecord)) continue;
            parameters.add(((ExportedRecord)object).getId());
        }
        return parameters;
    }

    public Parameters add(BigDecimal id) {
        this.ids.add(id);
        return this;
    }

    public boolean isNotEmpty() {
        return !this.ids.isEmpty();
    }

    public List<BigDecimal> getIds() {
        return new ArrayList<BigDecimal>(this.ids);
    }

    @Generated
    public String toString() {
        return "Parameters(columnName=" + this.getColumnName() + ", ids=" + this.getIds() + ")";
    }

    @ConstructorProperties(value={"columnName"})
    @Generated
    public Parameters(String columnName) {
        this.columnName = columnName;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }
}

