/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.sqlbc.export.sql.query;

import java.beans.ConstructorProperties;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.sqlbc.export.sql.query.Query;

public class UpdateForeignKey
implements Query {
    private final String tableName;
    private final BigDecimal lineId;
    private final Map<String, BigDecimal> columns = new LinkedHashMap<String, BigDecimal>();

    public void addColumn(String name, BigDecimal value) {
        if (value != null) {
            this.columns.put(name, value);
        }
    }

    @Override
    public String toSql() {
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        for (Map.Entry<String, BigDecimal> column : this.columns.entrySet()) {
            columns.add((CallSite)((Object)(column.getKey() + " = " + column.getValue())));
        }
        return String.format("UPDATE %s SET %s WHERE ID = %s;", this.tableName, StringUtils.join(columns, (String)", "), this.lineId);
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public BigDecimal getLineId() {
        return this.lineId;
    }

    @Generated
    public Map<String, BigDecimal> getColumns() {
        return this.columns;
    }

    @Generated
    public String toString() {
        return "UpdateForeignKey(tableName=" + this.getTableName() + ", lineId=" + this.getLineId() + ", columns=" + this.getColumns() + ")";
    }

    @ConstructorProperties(value={"tableName", "lineId"})
    @Generated
    public UpdateForeignKey(String tableName, BigDecimal lineId) {
        this.tableName = tableName;
        this.lineId = lineId;
    }
}

