/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.dto;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.mapper.DtoConstructor;
import org.cxbox.core.dto.mapper.ValueSupplier;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.Department;
import org.cxbox.model.workflow.entity.Workflow;
import org.cxbox.model.workflow.entity.WorkflowVersion;
import org.cxbox.source.dto.WorkflowDto;
import org.cxbox.source.dto.WorkflowDto_;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDtoConstructor
extends DtoConstructor<Workflow, WorkflowDto> {
    public WorkflowDtoConstructor() {
        super(Workflow.class, WorkflowDto.class);
    }

    public Map<DtoField<? super WorkflowDto, ?>, ValueSupplier<? super Workflow, ? super WorkflowDto, ?>> buildValueSuppliers() {
        return ImmutableMap.builder().put(WorkflowDto_.name, (mapping, entity) -> entity.getName()).put(WorkflowDto_.description, (mapping, entity) -> entity.getDescription()).put(WorkflowDto_.taskTypeCd, (mapping, entity) -> DictionaryType.TASK_TYPE.lookupValue(entity.getTaskTypeCd())).put(WorkflowDto_.deptShortName, (mapping, entity) -> Optional.ofNullable(entity.getDepartment()).map(Department::getShortName).orElse(null)).put(WorkflowDto_.activeVersionId, (mapping, entity) -> Optional.ofNullable(entity.getActiveVersion()).map(BaseEntity::getId).orElse(null)).put(WorkflowDto_.activeVersion, (mapping, entity) -> Optional.ofNullable(entity.getActiveVersion()).map(WorkflowVersion::getVersion).map(Objects::toString).orElse(null)).build();
    }
}

