/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.dto;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.mapper.DtoConstructor;
import org.cxbox.core.dto.mapper.ValueSupplier;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.source.dto.WorkflowStepDto;
import org.cxbox.source.dto.WorkflowStepDto_;
import org.springframework.stereotype.Service;

@Service
public class WorkflowStepDtoConstructor
extends DtoConstructor<WorkflowStep, WorkflowStepDto> {
    public WorkflowStepDtoConstructor() {
        super(WorkflowStep.class, WorkflowStepDto.class);
    }

    protected Map<DtoField<? super WorkflowStepDto, ?>, ValueSupplier<? super WorkflowStep, ? super WorkflowStepDto, ?>> buildValueSuppliers() {
        return ImmutableMap.builder().put(WorkflowStepDto_.name, (mapping, entity) -> entity.getName()).put(WorkflowStepDto_.linkedStatusKey, (mapping, entity) -> Optional.ofNullable(entity.getLinkedStatusCd()).map(LOV::getKey).orElse(null)).put(WorkflowStepDto_.linkedStatusValue, (mapping, entity) -> DictionaryType.TASK_STATUS.lookupValue(entity.getLinkedStatusCd())).put(WorkflowStepDto_.workflowVersion, (mapping, entity) -> entity.getWorkflowVersion().getVersion()).put(WorkflowStepDto_.workflowName, (mapping, entity) -> entity.getWorkflowVersion().getWorkflow().getName()).put(WorkflowStepDto_.overdueTransitionId, (mapping, entity) -> Optional.ofNullable(entity.getOverdueTransition()).map(BaseEntity::getId).orElse(null)).put(WorkflowStepDto_.overdueTransitionName, (mapping, entity) -> Optional.ofNullable(entity.getOverdueTransition()).map(WorkflowTransition::getName).orElse(null)).build();
    }
}

