/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.crudma;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractCrudmaService;
import org.cxbox.core.dto.LovUtils;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.core.util.ListPaging;
import org.cxbox.engine.workflow.WorkflowSettings;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.workflow.entity.TaskField;
import org.cxbox.source.dto.DmnTaskFieldsDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DmnTaskFieldsCrudmaService
extends AbstractCrudmaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmnTaskFieldsCrudmaService.class);
    private final Map<Class<?>, String> TYPES = ImmutableMap.builder().put(String.class, (Object)"string").put(Boolean.class, (Object)"boolean").put(Boolean.TYPE, (Object)"boolean").put(Integer.class, (Object)"integer").put(Integer.TYPE, (Object)"integer").put(Long.class, (Object)"long").put(Long.TYPE, (Object)"long").put(Double.class, (Object)"double").put(Double.TYPE, (Object)"double").put(BigDecimal.class, (Object)"double").put(LocalDateTime.class, (Object)"date").build();
    private final List<DmnTaskFieldsDto> TASK_FIELDS;
    private final List<FieldDTO> FIELD_DTO_LIST = ImmutableList.builder().add((Object)FieldDTO.disabledFilterableField((String)"id")).add((Object)FieldDTO.disabledFilterableField((String)"title")).add((Object)FieldDTO.disabledFilterableField((String)"key")).add((Object)FieldDTO.disabledFilterableField((String)"type")).add((Object)FieldDTO.disabledField((String)"values")).build();

    public DmnTaskFieldsCrudmaService(WorkflowSettings<?> workflowSettings, DictionaryCache dictionaryCache, JpaDao jpaDao) {
        this.TASK_FIELDS = this.buildTaskFields(workflowSettings, dictionaryCache, jpaDao);
    }

    public ResultPage<? extends DataResponseDTO> getAll(BusinessComponent bc) {
        return ListPaging.getResultPage(this.TASK_FIELDS, (QueryParameters)bc.getParameters());
    }

    public long count(BusinessComponent bc) {
        return this.TASK_FIELDS.size();
    }

    public MetaDTO getMeta(BusinessComponent bc) {
        return this.buildMeta(this.FIELD_DTO_LIST);
    }

    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        return this.buildMeta(Collections.emptyList());
    }

    private List<DmnTaskFieldsDto> buildTaskFields(WorkflowSettings<?> workflowSettings, DictionaryCache dictionaryCache, JpaDao jpaDao) {
        ArrayList<DmnTaskFieldsDto> taskFields = new ArrayList<DmnTaskFieldsDto>();
        for (TaskField taskField : jpaDao.getList(TaskField.class)) {
            Field field = FieldUtils.getField(workflowSettings.getDtoClass(), (String)taskField.getKey(), (boolean)true);
            if (field == null) {
                log.error("No field with name " + taskField.getKey() + " in class");
                continue;
            }
            try {
                taskFields.add(new DmnTaskFieldsDto(String.valueOf(taskFields.size()), taskField.getTitle(), taskField.getKey(), this.getDmnType(field.getType()), this.getValues(dictionaryCache, field)));
            }
            catch (Exception e) {
                log.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ImmutableList.copyOf(taskFields);
    }

    private String getDmnType(Class<?> classType) {
        String dmnType = this.TYPES.get(classType);
        if (dmnType == null) {
            throw new IllegalArgumentException("\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0442\u0438\u043f\u0430 " + classType.getName() + " \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u0430 DMN \u0434\u0432\u0438\u0436\u043a\u043e\u043c.");
        }
        return dmnType;
    }

    private String getValues(DictionaryCache dictionaryCache, Field field) {
        IDictionaryType dictionaryType = LovUtils.getType((Field)field);
        if (dictionaryType == null) {
            return null;
        }
        return JsonUtils.writeValue((Object)((String[])dictionaryCache.getAll(dictionaryType).stream().map(SimpleDictionary::getValue).toArray(String[]::new)));
    }
}

