/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dict.WorkflowDictionaries;
import org.cxbox.core.dict.WorkflowDictionaryType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.workflow.entity.WorkflowCondition;
import org.cxbox.model.workflow.entity.WorkflowCondition_;
import org.cxbox.model.workflow.entity.WorkflowStepConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowStepConditionGroup_;
import org.cxbox.model.workflow.entity.WorkflowStepField;
import org.cxbox.model.workflow.entity.WorkflowStepField_;
import org.cxbox.model.workflow.entity.WorkflowTaskChildBcAvailability;
import org.cxbox.model.workflow.entity.WorkflowTaskChildBcAvailability_;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup_;
import org.cxbox.source.dto.WorkflowConditionDto;
import org.cxbox.source.dto.WorkflowConditionDto_;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowConditionServiceImpl<D extends WorkflowConditionDto, E extends WorkflowCondition>
extends VersionAwareResponseService<D, E> {
    public BaseWorkflowConditionServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected Specification<E> getParentSpecification(BusinessComponent bc) {
        Long parentId = bc.getParentIdAsLong();
        if (WorkflowServiceAssociation.wfStepCondRecommendedAssignee.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.stepConditionGroup).get(WorkflowStepConditionGroup_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfStepFieldCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.stepField).get(WorkflowStepField_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfChildBcAvailabilityCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.wfChildBcAvailability).get(WorkflowTaskChildBcAvailability_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfTranCondValid.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTransitionCond.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfPostFuncGroupCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.transitionConditionGroup).get(WorkflowTransitionConditionGroup_.id), (Object)parentId);
        }
        return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfStepCondRecommendedAssignee.isBc((BcIdentifier)bc)) {
            entity.setStepConditionGroup((WorkflowStepConditionGroup)this.baseDAO.findById(WorkflowStepConditionGroup.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.STEP_CONDITION);
        } else if (WorkflowServiceAssociation.wfStepFieldCond.isBc((BcIdentifier)bc)) {
            entity.setStepField((WorkflowStepField)this.baseDAO.findById(WorkflowStepField.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.STEP_FIELD_CONDITION);
        } else if (WorkflowServiceAssociation.wfChildBcAvailabilityCond.isBc((BcIdentifier)bc)) {
            entity.setWfChildBcAvailability((WorkflowTaskChildBcAvailability)this.baseDAO.findById(WorkflowTaskChildBcAvailability.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.CHILD_BC_CONDITION);
        } else if (WorkflowServiceAssociation.wfTranCondValid.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTransitionCond.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfPostFuncGroupCond.isBc((BcIdentifier)bc)) {
            entity.setTransitionConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.TRANSITION_CONDITION);
        }
        entity.setCondCd(WorkflowDictionaries.WfCondition.ALWAYS_HIDDEN);
        this.baseDAO.save(entity);
        return new CreateResult((DataResponseDTO)((WorkflowConditionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected abstract E create(BusinessComponent var1);

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO((DataResponseDTO)((WorkflowConditionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowConditionDto_.seq)) {
            entity.setSeq(((WorkflowConditionDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowConditionDto_.condCd)) {
            entity.setCondCd(WorkflowDictionaryType.WF_COND.lookupName(((WorkflowConditionDto)((Object)dto)).getCondCd()));
        }
        if (dto.isFieldChanged(WorkflowConditionDto_.dmn)) {
            entity.setDmn(((WorkflowConditionDto)((Object)dto)).getDmn());
        }
    }

    public Actions<D> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

